/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep;

import com.jetbrains.launcher.AppExitCode;
import com.jetbrains.launcher.AppFiles;
import com.jetbrains.launcher.AppName;
import com.jetbrains.launcher.AppWrapperArguments;
import com.jetbrains.launcher.BaseApplicationContext;
import com.jetbrains.launcher.Destroyer;
import com.jetbrains.launcher.Initializer;
import com.jetbrains.launcher.JLThread;
import com.jetbrains.launcher.RunningService;
import com.jetbrains.launcher.ShutdownContextImpl;
import com.jetbrains.launcher.ShutdownService;
import com.jetbrains.launcher.StartKind;
import com.jetbrains.launcher.StatusDescriptor;
import com.jetbrains.launcher.contexts.ShutdownContext;
import com.jetbrains.launcher.contexts.StartupContext;
import com.jetbrains.launcher.contexts.StatusContext;
import com.jetbrains.launcher.exceptions.ShutdownException;
import com.jetbrains.launcher.exceptions.StartupException;
import com.jetbrains.launcher.exceptions.StatusException;
import com.jetbrains.launcher.transport.ConnectionData;
import com.jetbrains.launcher.transport.Request;
import com.jetbrains.launcher.transport.RequestHandler;
import com.jetbrains.launcher.transport.Response;
import com.jetbrains.launcher.transport.ResponseWriter;
import com.jetbrains.launcher.transport.Server;
import com.jetbrains.launcher.transport.StateAwareSocketOutputStream;
import com.jetbrains.launcher.util.ConsoleProxy;
import com.jetbrains.launcher.util.Event;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.ProcessUtil;
import com.jetbrains.launcher.util.PropertiesUtil;
import com.jetbrains.launcher.util.RuntimeUtil;
import com.jetbrains.launcher.util.SystemUtil;
import com.jetbrains.launcher.util.ThreadUtil;
import com.jetbrains.launcher.util.TimeoutException;
import com.jetbrains.launcher.util.WaitFor;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppStarter
extends BaseApplicationContext
implements StartupContext,
ShutdownService,
StatusContext {
    @NotNull
    private final Event.LastingEvent myShutdown;
    @NotNull
    private final RunningService myRunningService;
    @Nullable
    private Map<String, String> myRestartState;

    public static void main(final @NotNull String[] args) {
        AppExitCode errorCode;
        if (args == null) {
            AppStarter.$$$reportNull$$$0(0);
        }
        if ((errorCode = Initializer.runWithContext((Initializer.ApplicationProcess)new Initializer.ApplicationProcess(){

            @Nullable
            public AppExitCode run() {
                return new AppStarter(new AppWrapperArguments(args)).start();
            }
        })) != null) {
            SystemUtil.exit((int)errorCode.getValue());
        }
    }

    private AppStarter(@NotNull AppWrapperArguments args) {
        if (args == null) {
            AppStarter.$$$reportNull$$$0(1);
        }
        super(args);
        this.myShutdown = new Event.LastingEvent();
        this.myRunningService = args.createRunningService(this);
    }

    @Nullable
    private AppExitCode start() {
        AppName appName = this.getAppName();
        this.myArgs.getLogger().debug("Starting " + appName.getName() + "...");
        AppExitCode appExitCode = this.doStart();
        if (appExitCode == null) {
            this.myArgs.getLogger().debug(appName.getCapitalizedName() + " was started");
        } else {
            this.myArgs.getLogger().debug(appName.getCapitalizedName() + " failed to start with exit code " + appExitCode);
        }
        return appExitCode;
    }

    @Nullable
    private AppExitCode doStart() {
        try {
            RuntimeUtil.saveAppPid((AppFiles)this.getAppFiles(), (int)ProcessUtil.getCurrentPid());
        }
        catch (IOException e) {
            this.myArgs.getLogger().internalError("Failed to determine the current process ID", e);
            return AppExitCode.RESTART_ERROR;
        }
        try {
            this.readRestartStateIfNeeded();
        }
        catch (IOException e) {
            this.myArgs.getLogger().internalError("Failed to read the " + this.getAppName().getName() + " restart state", e);
            return AppExitCode.RESTART_ERROR;
        }
        ConsoleProxy.init();
        try {
            this.startServer();
        }
        catch (IOException e) {
            this.myArgs.getLogger().internalError("Failed to start application wrapper server", e);
            return AppExitCode.RESTART_ERROR;
        }
        Destroyer.get().addStep(new Runnable(){

            @Override
            public void run() {
                AppStarter.this.requestShutdown(AppExitCode.EXIT);
                AppStarter.this.myShutdown.waitFor();
            }
        });
        try {
            this.myRunningService.start((StartupContext)this);
        }
        catch (StartupException e) {
            this.myArgs.getLogger().appError(e);
            return e.getExitCode();
        }
        catch (Throwable e) {
            this.myArgs.getLogger().internalError("Failed to start " + this.getAppName().getName(), e);
            return AppExitCode.RESTART_ERROR;
        }
        this.startRuntimeFilesMonitoring();
        return null;
    }

    private void startServer() throws IOException {
        final Server server = new Server("Application Wrapper Server", this.myArgs.getLogger());
        Destroyer.get().addStep(new Runnable(){

            @Override
            public void run() {
                server.shutdown();
            }
        });
        server.addFrequentUrl("/status");
        server.addHandler("/status", new RequestHandler(){

            @Override
            public void processRequest(@NotNull Request request, @NotNull ResponseWriter responseWriter) throws IOException {
                if (request == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (responseWriter == null) {
                    4.$$$reportNull$$$0(1);
                }
                try {
                    StatusDescriptor status = AppStarter.this.myRunningService.getStatus((StatusContext)AppStarter.this);
                    responseWriter.write(new Response(204, status.asString()));
                }
                catch (StatusException e) {
                    responseWriter.write(new Response(500, e.getMessage()));
                }
                catch (Throwable e) {
                    AppStarter.this.myArgs.getLogger().appError(e);
                    responseWriter.write(new Response(500, e.toString()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "request";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "responseWriter";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/launcher/ep/AppStarter$4";
                objectArray[2] = "processRequest";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        server.addHandler("/dumpThreads", new RequestHandler(){

            @Override
            public void processRequest(@NotNull Request request, @NotNull ResponseWriter responseWriter) throws IOException {
                if (request == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (responseWriter == null) {
                    5.$$$reportNull$$$0(1);
                }
                try {
                    responseWriter.write(new Response(204, AppStarter.this.getDiagnosticService().dumpThreads()));
                }
                catch (Throwable e) {
                    AppStarter.this.myArgs.getLogger().internalError("Failed to dump " + AppStarter.this.getAppName().getName() + " threads", e);
                    responseWriter.write(new Response(500, e.toString()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "request";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "responseWriter";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/launcher/ep/AppStarter$5";
                objectArray[2] = "processRequest";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        server.addHandler("/dumpHeap", new RequestHandler(){

            @Override
            public void processRequest(@NotNull Request request, @NotNull ResponseWriter responseWriter) throws IOException {
                if (request == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (responseWriter == null) {
                    6.$$$reportNull$$$0(1);
                }
                try {
                    File file = AppStarter.this.getDiagnosticService().dumpHeapToFile();
                    responseWriter.write(new Response(204, file.getAbsolutePath()));
                }
                catch (IOException e) {
                    AppStarter.this.myArgs.getLogger().internalError("Failed to dump " + AppStarter.this.getAppName().getName() + " memory heap", e);
                    responseWriter.write(new Response(500, e.getMessage()));
                }
                catch (Throwable e) {
                    AppStarter.this.myArgs.getLogger().internalError("Failed to dump " + AppStarter.this.getAppName().getName() + " memory heap", e);
                    responseWriter.write(new Response(500, e.toString()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "request";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "responseWriter";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/launcher/ep/AppStarter$6";
                objectArray[2] = "processRequest";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        server.addCriticalUrl("/attach");
        server.addHandler("/attach", new RequestHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processRequest(@NotNull Request request, @NotNull ResponseWriter responseWriter) throws IOException {
                if (request == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (responseWriter == null) {
                    7.$$$reportNull$$$0(1);
                }
                boolean stderr = Boolean.parseBoolean((String)request.getParams().get("stderr"));
                Socket socket = responseWriter.write(new Response(200, null));
                final StateAwareSocketOutputStream stream = new StateAwareSocketOutputStream(socket, "Request: " + request.describe());
                ConsoleProxy.addListener(stderr, stream.getOutputStream());
                try {
                    new WaitFor<RuntimeException>(null){

                        protected boolean condition() {
                            return AppStarter.this.myShutdown.isFinished() || stream.isClosed();
                        }
                    };
                }
                catch (TimeoutException ignore) {
                }
                catch (InterruptedException ignore) {
                }
                finally {
                    ConsoleProxy.removeListener(stderr, stream.getOutputStream());
                    stream.finish();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "request";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "responseWriter";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/launcher/ep/AppStarter$7";
                objectArray[2] = "processRequest";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        server.addCriticalUrl("/restart");
        server.addHandler("/restart", new RequestHandler(){

            @Override
            public void processRequest(@NotNull Request request, @NotNull ResponseWriter responseWriter) throws IOException {
                if (request == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (responseWriter == null) {
                    8.$$$reportNull$$$0(1);
                }
                boolean soft = Boolean.parseBoolean((String)request.getParams().get("soft"));
                AppStarter.this.requestShutdown(AppExitCode.RESTART, soft);
                AppStarter.this.myShutdown.waitFor();
                responseWriter.write(new Response(204, null));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "request";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "responseWriter";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/launcher/ep/AppStarter$8";
                objectArray[2] = "processRequest";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        server.addCriticalUrl("/stop");
        server.addHandler("/stop", new RequestHandler(){

            @Override
            public void processRequest(@NotNull Request request, @NotNull ResponseWriter responseWriter) throws IOException {
                if (request == null) {
                    9.$$$reportNull$$$0(0);
                }
                if (responseWriter == null) {
                    9.$$$reportNull$$$0(1);
                }
                boolean soft = Boolean.parseBoolean((String)request.getParams().get("soft"));
                AppStarter.this.requestShutdown(AppExitCode.EXIT, soft);
                AppStarter.this.myShutdown.waitFor();
                responseWriter.write(new Response(204, null));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "request";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "responseWriter";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/launcher/ep/AppStarter$9";
                objectArray[2] = "processRequest";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        server.start();
        RuntimeUtil.saveConnectionData((AppFiles)this.getAppFiles(), (ConnectionData)server.getConnectionData());
        RuntimeUtil.removeStartFlag((AppFiles)this.getAppFiles());
        if (RuntimeUtil.isExitFlagSet((AppFiles)this.getAppFiles())) {
            this.requestShutdown(AppExitCode.EXIT);
        }
    }

    private void startRuntimeFilesMonitoring() {
        final List runtimeFiles = RuntimeUtil.getRuntimeFilesToMonitor((AppFiles)this.getAppFiles());
        JLThread.start((String)"Runtime Files Monitoring", (boolean)true, (Runnable)new Runnable(){

            @Override
            public void run() {
                Destroyer destroyer = Destroyer.get();
                while (!destroyer.isDestroying()) {
                    for (File runtimeFile : runtimeFiles) {
                        AppStarter.this.checkRuntimeFile(runtimeFile);
                    }
                    ThreadUtil.sleep((long)5000L);
                }
            }
        });
    }

    private void checkRuntimeFile(@NotNull File runtimeFile) {
        if (runtimeFile == null) {
            AppStarter.$$$reportNull$$$0(2);
        }
        if (!runtimeFile.isFile()) {
            this.myArgs.getLogger().internalError("Runtime file was deleted: " + runtimeFile.getAbsolutePath());
            this.myArgs.getLogger().internalError("Requesting shutdown...");
            this.requestShutdown(AppExitCode.EXIT);
        }
    }

    private void readRestartStateIfNeeded() throws IOException {
        File restartStateFile = this.getRestartStateFile();
        if (this.getStartKind().isRestart() && restartStateFile.isFile()) {
            Properties properties = new Properties();
            PropertiesUtil.loadFromFile((Properties)properties, (File)restartStateFile);
            this.myRestartState = PropertiesUtil.toMap((Properties)properties);
        }
        if (!FileUtil.delete((File)restartStateFile)) {
            this.myArgs.getLogger().internalError("Failed to delete the " + this.getAppName().getName() + " restart state file");
        }
    }

    @NotNull
    public StartKind getStartKind() {
        StartKind startKind = this.myArgs.getStartKind();
        if (startKind == null) {
            AppStarter.$$$reportNull$$$0(3);
        }
        return startKind;
    }

    @Nullable
    public Map<String, String> getRestartState() {
        return this.myRestartState == null ? null : Collections.unmodifiableMap(this.myRestartState);
    }

    @NotNull
    public ShutdownService getShutdownService() {
        AppStarter appStarter = this;
        if (appStarter == null) {
            AppStarter.$$$reportNull$$$0(4);
        }
        return appStarter;
    }

    public void requestShutdown(@NotNull AppExitCode exitCode) {
        if (exitCode == null) {
            AppStarter.$$$reportNull$$$0(5);
        }
        this.requestShutdown(exitCode, false);
    }

    public void requestShutdown(@NotNull AppExitCode exitCode, boolean soft) {
        if (exitCode == null) {
            AppStarter.$$$reportNull$$$0(6);
        }
        this.doRequestShutdown(exitCode, null, soft);
    }

    public void requestRestart(@NotNull Map<String, String> restartState) {
        if (restartState == null) {
            AppStarter.$$$reportNull$$$0(7);
        }
        try {
            Properties properties = new Properties();
            properties.putAll(restartState);
            PropertiesUtil.saveToFile((Properties)properties, (File)this.getRestartStateFile());
        }
        catch (IOException e) {
            this.myArgs.getLogger().internalError("Failed to save the " + this.getAppName().getName() + " restart state", e);
        }
        this.doRequestShutdown(AppExitCode.RESTART, restartState, false);
    }

    private void doRequestShutdown(final @NotNull AppExitCode exitCode, final @Nullable Map<String, String> restartState, final boolean soft) {
        if (exitCode == null) {
            AppStarter.$$$reportNull$$$0(8);
        }
        if (this.myShutdown.start()) {
            this.myArgs.getLogger().debug("Shutdown requested (exitCode: " + exitCode + ", soft: " + soft + ", restartState: " + restartState + ")");
            RuntimeUtil.removeStartFlag((AppFiles)this.getAppFiles());
            JLThread.start((String)(this.getAppName().getCapitalizedName() + " Shutdown"), (boolean)false, (Runnable)new Runnable(){

                @Override
                public void run() {
                    SystemUtil.exit((int)AppStarter.this.doShutdown(exitCode, restartState, soft).getValue());
                }
            });
        }
    }

    @NotNull
    private File getRestartStateFile() {
        File file = new File(this.myArgs.getAppFiles().getLauncherLogsFolder(), "restart.state");
        if (file == null) {
            AppStarter.$$$reportNull$$$0(9);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private AppExitCode doShutdown(@NotNull AppExitCode exitCode, @Nullable Map<String, String> restartState, boolean soft) {
        AppExitCode appExitCode;
        if (exitCode == null) {
            AppStarter.$$$reportNull$$$0(10);
        }
        try {
            AppExitCode appExitCode2 = this.myRunningService.shutdown((ShutdownContext)new ShutdownContextImpl(this.myArgs, exitCode, restartState, soft));
            appExitCode = appExitCode2;
        }
        catch (ShutdownException e) {
            this.myArgs.getLogger().appError(e);
            AppExitCode appExitCode3 = e.getExitCode();
            AppExitCode appExitCode4 = appExitCode3;
            if (appExitCode4 == null) {
                AppStarter.$$$reportNull$$$0(12);
            }
            return appExitCode4;
        }
        catch (Throwable e) {
            this.myArgs.getLogger().internalError("Failed to shut " + this.getAppName().getName() + " down", e);
            AppExitCode appExitCode5 = exitCode;
            this.myShutdown.finish();
            AppExitCode appExitCode6 = appExitCode5;
            if (appExitCode6 == null) {
                AppStarter.$$$reportNull$$$0(13);
            }
            return appExitCode6;
        }
        finally {
            this.myShutdown.finish();
        }
        if (appExitCode == null) {
            AppStarter.$$$reportNull$$$0(11);
        }
        return appExitCode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtimeFile";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/AppStarter";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exitCode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restartState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/AppStarter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartKind";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShutdownService";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestartStateFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "doShutdown";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "main";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkRuntimeFile";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "requestShutdown";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "requestRestart";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doRequestShutdown";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doShutdown";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

