/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util;

import com.jetbrains.launcher.AppFiles;
import com.jetbrains.launcher.Static;
import com.jetbrains.launcher.util.DateUtil;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.HotSpotDiagnosticMXBeanWrapper;
import com.jetbrains.launcher.util.JavaUtil;
import com.jetbrains.launcher.util.ProcessUtil;
import com.jetbrains.launcher.util.RuntimeUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DiagnosticUtil {
    @Static
    @NotNull
    private static final HotSpotDiagnosticMXBeanWrapper ourHotSpotDiagnosticMXBean = new HotSpotDiagnosticMXBeanWrapper();

    public static void init() {
    }

    @NotNull
    public static File dumpHeapToFile(@NotNull AppFiles appFiles) throws IOException {
        if (appFiles == null) {
            DiagnosticUtil.$$$reportNull$$$0(0);
        }
        File file = RuntimeUtil.getAppHeapDumpFile((AppFiles)appFiles);
        DiagnosticUtil.dumpHeapToFile(file);
        File file2 = file;
        if (file2 == null) {
            DiagnosticUtil.$$$reportNull$$$0(1);
        }
        return file2;
    }

    public static void dumpHeapToFile(@NotNull File file) throws IOException {
        if (file == null) {
            DiagnosticUtil.$$$reportNull$$$0(2);
        }
        if (!ourHotSpotDiagnosticMXBean.dumpHeapToFile(file)) {
            DiagnosticUtil.dumpHeapToFileUsingJMap(file);
        }
    }

    private static void dumpHeapToFileUsingJMap(@NotNull File file) throws IOException {
        File jmap;
        if (file == null) {
            DiagnosticUtil.$$$reportNull$$$0(3);
        }
        if ((jmap = JavaUtil.findJMapTool()) == null) {
            throw new IOException("\"jmap\" tool is not found");
        }
        int exitCode = ProcessUtil.runSimpleCommand((String[])JavaUtil.getJMapToolCommandLine((File)jmap, (File)file, (int)ProcessUtil.getCurrentPid()));
        if (exitCode != 0) {
            throw new IOException("Process exited with code " + exitCode);
        }
    }

    @NotNull
    public static File dumpThreadsToFile(@NotNull AppFiles appFiles) throws IOException {
        if (appFiles == null) {
            DiagnosticUtil.$$$reportNull$$$0(4);
        }
        File file = RuntimeUtil.getAppThreadDumpFile((AppFiles)appFiles);
        DiagnosticUtil.dumpThreadsToFile(file);
        File file2 = file;
        if (file2 == null) {
            DiagnosticUtil.$$$reportNull$$$0(5);
        }
        return file2;
    }

    public static void dumpThreadsToFile(@NotNull File file) throws IOException {
        if (file == null) {
            DiagnosticUtil.$$$reportNull$$$0(6);
        }
        FileUtil.saveText((File)file, (String)DiagnosticUtil.dumpThreads());
    }

    @NotNull
    public static String dumpThreads() {
        StringWriter buf = new StringWriter();
        PrintWriter pw = new PrintWriter(buf);
        DiagnosticUtil.doDumpThreads(pw);
        pw.flush();
        String string = buf.toString().trim();
        if (string == null) {
            DiagnosticUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static void doDumpThreads(@NotNull PrintWriter pw) {
        if (pw == null) {
            DiagnosticUtil.$$$reportNull$$$0(8);
        }
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        Map<Long, ThreadInfo> threadInfos = DiagnosticUtil.makeIndexById(ManagementFactory.getThreadMXBean().dumpAllThreads(true, true));
        pw.println(DateUtil.getPrettyDateTimeString());
        pw.println(MessageFormat.format("Full thread dump {0} ({1} {2}):", System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), System.getProperty("java.vm.info")));
        pw.println();
        for (Map.Entry<Thread, StackTraceElement[]> entry : threads.entrySet()) {
            LockInfo lockInfo;
            Thread.State threadState;
            ThreadGroup group;
            Thread thread = entry.getKey();
            ThreadInfo threadInfo = threadInfos.get(thread.getId());
            pw.print(MessageFormat.format("\"{0}\"", thread.getName()));
            if (thread.isDaemon()) {
                pw.print(" daemon");
            }
            if ((group = thread.getThreadGroup()) != null) {
                pw.print(MessageFormat.format(" group={0}", group.getName().replaceAll("\\s", "_")));
            }
            pw.print(MessageFormat.format(" prio={0} tid={1} nid={1}", thread.getPriority(), thread.getId()));
            Thread.State state = threadState = threadInfo == null ? thread.getState() : threadInfo.getThreadState();
            if (threadState == Thread.State.RUNNABLE) {
                pw.print(" runnable");
            } else if (threadState == Thread.State.WAITING || threadState == Thread.State.TIMED_WAITING) {
                pw.print(" waiting");
            } else if (threadState == Thread.State.BLOCKED) {
                pw.print(" blocked");
            }
            if (threadInfo != null) {
                String lock = threadInfo.getLockName();
                if (lock != null) {
                    pw.print(MessageFormat.format(" on {0}", lock));
                    String lockOwner = threadInfo.getLockOwnerName();
                    if (lockOwner != null) {
                        pw.println();
                        pw.print(MessageFormat.format("   by \"{0}\" id={1}", lockOwner, threadInfo.getLockOwnerId()));
                    }
                }
                if (threadInfo.isSuspended()) {
                    pw.print(" (suspended)");
                }
                if (threadInfo.isInNative()) {
                    pw.print(" (in native)");
                }
            }
            pw.println();
            pw.print("   java.lang.Thread.State: " + threadState.name());
            pw.println();
            if (threadInfo != null && (lockInfo = threadInfo.getLockInfo()) != null) {
                if (threadState == Thread.State.BLOCKED) {
                    pw.println("\t-  blocked on " + lockInfo);
                } else if (threadState == Thread.State.WAITING || threadState == Thread.State.TIMED_WAITING) {
                    pw.println("\t-  waiting on " + lockInfo);
                }
            }
            MonitorInfo[] lockedMonitors = threadInfo == null ? null : threadInfo.getLockedMonitors();
            StackTraceElement[] stackTrace = threadInfo == null ? entry.getValue() : threadInfo.getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                pw.println("\tat " + stackTrace[i]);
                if (lockedMonitors == null) continue;
                for (LockInfo lockInfo2 : lockedMonitors) {
                    if (((MonitorInfo)lockInfo2).getLockedStackDepth() != i) continue;
                    pw.println("\t-  locked " + lockInfo2);
                }
            }
            pw.println();
            LockInfo[] lockedSynchronizers = threadInfo == null ? null : threadInfo.getLockedSynchronizers();
            if (lockedSynchronizers == null) continue;
            pw.println("   Locked ownable synchronizers:");
            if (lockedSynchronizers.length == 0) {
                pw.println("\t- None");
            } else {
                for (LockInfo lockInfo3 : lockedSynchronizers) {
                    pw.println("\t- " + lockInfo3);
                }
            }
            pw.println();
        }
    }

    @NotNull
    private static Map<Long, ThreadInfo> makeIndexById(@NotNull ThreadInfo[] threadInfos) {
        if (threadInfos == null) {
            DiagnosticUtil.$$$reportNull$$$0(9);
        }
        HashMap<Long, ThreadInfo> result = new HashMap<Long, ThreadInfo>();
        for (ThreadInfo threadInfo : threadInfos) {
            result.put(threadInfo.getThreadId(), threadInfo);
        }
        HashMap<Long, ThreadInfo> hashMap = result;
        if (hashMap == null) {
            DiagnosticUtil.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFiles";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/util/DiagnosticUtil";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pw";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/util/DiagnosticUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpHeapToFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpThreadsToFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpThreads";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "makeIndexById";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "dumpHeapToFile";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "dumpHeapToFileUsingJMap";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dumpThreadsToFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doDumpThreads";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "makeIndexById";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

