/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher;

import com.jetbrains.launcher.AppFixedFilesEx;
import com.jetbrains.launcher.AppFixedFilesImpl;
import com.jetbrains.launcher.CoreArguments;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherCoreContext;
import com.jetbrains.launcher.LauncherCoreContextImpl;
import com.jetbrains.launcher.configs.LauncherConfig;
import com.jetbrains.launcher.configs.LauncherConfigEx;
import com.jetbrains.launcher.util.StringUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LauncherCoreContextFactory {
    @NotNull
    public static CoreArguments createCoreArguments(@NotNull File appHome) {
        if (appHome == null) {
            LauncherCoreContextFactory.$$$reportNull$$$0(0);
        }
        AppFixedFilesImpl appFixedFiles = new AppFixedFilesImpl(appHome);
        CoreArguments coreArguments = new CoreArguments((AppFixedFilesEx)appFixedFiles, LauncherCoreContextFactory.isJavaApplication((AppFixedFilesEx)appFixedFiles));
        if (coreArguments == null) {
            LauncherCoreContextFactory.$$$reportNull$$$0(1);
        }
        return coreArguments;
    }

    private static boolean isJavaApplication(@NotNull AppFixedFilesEx appFixedFiles) {
        if (appFixedFiles == null) {
            LauncherCoreContextFactory.$$$reportNull$$$0(2);
        }
        for (LauncherConfigEx.Parser configParser : LauncherConfigEx.getParsers()) {
            if (!configParser.isJavaApplication() || !configParser.isApplicable(appFixedFiles)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static LauncherCoreContext createCoreContext(@NotNull CoreArguments args) throws InitException {
        if (args == null) {
            LauncherCoreContextFactory.$$$reportNull$$$0(3);
        }
        LauncherCoreContext launcherCoreContext = LauncherCoreContextFactory.createCoreContext(args, LauncherCoreContextFactory.createLauncherConfig(args));
        if (launcherCoreContext == null) {
            LauncherCoreContextFactory.$$$reportNull$$$0(4);
        }
        return launcherCoreContext;
    }

    @NotNull
    private static LauncherCoreContext createCoreContext(@NotNull CoreArguments args, @NotNull LauncherConfig launcherConfig) {
        if (args == null) {
            LauncherCoreContextFactory.$$$reportNull$$$0(5);
        }
        if (launcherConfig == null) {
            LauncherCoreContextFactory.$$$reportNull$$$0(6);
        }
        LauncherCoreContextImpl launcherCoreContextImpl = new LauncherCoreContextImpl(args, launcherConfig);
        if (launcherCoreContextImpl == null) {
            LauncherCoreContextFactory.$$$reportNull$$$0(7);
        }
        return launcherCoreContextImpl;
    }

    @NotNull
    private static LauncherConfig createLauncherConfig(@NotNull CoreArguments args) throws InitException {
        if (args == null) {
            LauncherCoreContextFactory.$$$reportNull$$$0(8);
        }
        AppFixedFilesEx appFixedFiles = args.getAppFixedFiles();
        List<LauncherConfigEx.Parser> configParsers = LauncherConfigEx.getParsers();
        for (LauncherConfigEx.Parser configParser : configParsers) {
            if (!configParser.isApplicable(appFixedFiles)) continue;
            LauncherConfigEx launcherConfigEx = configParser.parseConfig(appFixedFiles);
            if (launcherConfigEx == null) {
                LauncherCoreContextFactory.$$$reportNull$$$0(9);
            }
            return launcherConfigEx;
        }
        StringBuilder sb = new StringBuilder();
        for (LauncherConfigEx.Parser configParser : configParsers) {
            StringUtil.append((StringBuilder)sb, (String)", ", (String)configParser.getConfigFile(appFixedFiles).getURL().toExternalForm());
        }
        sb.insert(0, "None of the following launcher configuration files found: ");
        throw new InitException(sb.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appHome";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/LauncherCoreContextFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFixedFiles";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/LauncherCoreContextFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCoreArguments";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCoreContext";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createLauncherConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCoreArguments";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isJavaApplication";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCoreContext";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createLauncherConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

