/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep;

import com.jetbrains.launcher.Static;
import com.jetbrains.launcher.log.ConsoleLogger;
import com.jetbrains.launcher.util.ClasspathUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class AppHome {
    @Static
    @NotNull
    private static final File ourAppHome;

    @NotNull
    public static File get() {
        File file = ourAppHome;
        if (file == null) {
            AppHome.$$$reportNull$$$0(0);
        }
        return file;
    }

    @NotNull
    private static File findAppHome() throws IOException {
        File launcherJar = ClasspathUtil.getBootClasspathEntry();
        File launcherLibDir = launcherJar.isFile() ? AppHome.getParent(launcherJar) : launcherJar;
        File file = AppHome.getParent(AppHome.getParent(launcherLibDir));
        if (file == null) {
            AppHome.$$$reportNull$$$0(1);
        }
        return file;
    }

    @NotNull
    private static File getParent(@NotNull File file) throws IOException {
        File parentFile;
        if (file == null) {
            AppHome.$$$reportNull$$$0(2);
        }
        if ((parentFile = file.getParentFile()) == null) {
            throw new IOException("Failed to get parent directory for file: " + file.getAbsolutePath());
        }
        File file2 = parentFile;
        if (file2 == null) {
            AppHome.$$$reportNull$$$0(3);
        }
        return file2;
    }

    static {
        try {
            ourAppHome = AppHome.findAppHome();
        }
        catch (IOException e) {
            ConsoleLogger.error((String)("Unable to find application root directory: " + e.getMessage()));
            ConsoleLogger.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/AppHome";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findAppHome";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/AppHome";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

