/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.AppConfigFiles;
import com.jetbrains.launcher.AppFilesEx;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.Resource;
import com.jetbrains.launcher.ep.commands.BaseProcessBasedCommand;
import com.jetbrains.launcher.log.ConsoleLogger;
import com.jetbrains.launcher.util.ExceptionUtil;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseServiceSubCommand
extends BaseProcessBasedCommand {
    @NotNull
    private final Logger LOG = Logger.getLogger(BaseServiceSubCommand.class);

    @Override
    @NotNull
    public String getFullName() {
        String string = this.getServiceCommandName() + " " + this.getName();
        if (string == null) {
            BaseServiceSubCommand.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected abstract String getServiceCommandName();

    @Override
    @NotNull
    protected LauncherExitCode doRun(@NotNull LauncherContextEx context) throws InitException {
        if (context == null) {
            BaseServiceSubCommand.$$$reportNull$$$0(1);
        }
        if (this.requiresInstalledService() && !this.serviceExists(context, this.getCurrentServiceName(context), true)) {
            this.LOG.error((Object)(context.getAppConfig().getAppName().getCapitalizedName() + " " + this.getServiceTypeName() + " is not installed"));
            LauncherExitCode launcherExitCode = LauncherExitCode.ILLEGAL_STATE;
            if (launcherExitCode == null) {
                BaseServiceSubCommand.$$$reportNull$$$0(2);
            }
            return launcherExitCode;
        }
        LauncherExitCode code = this.configureService(context);
        if (code != null) {
            LauncherExitCode launcherExitCode = code;
            if (launcherExitCode == null) {
                BaseServiceSubCommand.$$$reportNull$$$0(3);
            }
            return launcherExitCode;
        }
        code = this.afterServiceConfigured(context);
        if (code != null) {
            LauncherExitCode launcherExitCode = code;
            if (launcherExitCode == null) {
                BaseServiceSubCommand.$$$reportNull$$$0(4);
            }
            return launcherExitCode;
        }
        LauncherExitCode launcherExitCode = this.doPureRun(context);
        if (launcherExitCode == null) {
            BaseServiceSubCommand.$$$reportNull$$$0(5);
        }
        return launcherExitCode;
    }

    protected abstract boolean requiresInstalledService();

    @Nullable
    public LauncherExitCode configureService(@NotNull LauncherContextEx context) throws InitException {
        if (context == null) {
            BaseServiceSubCommand.$$$reportNull$$$0(6);
        }
        String oldServiceName = this.getOldServiceName(context);
        String currentServiceName = this.getCurrentServiceName(context);
        if (oldServiceName != null && !oldServiceName.equals(currentServiceName) && this.serviceExists(context, oldServiceName, false)) {
            this.LOG.warn((Object)("Old " + this.getServiceTypeName() + " with the " + this.getServiceNameName() + " \"" + oldServiceName + "\" exists, uninstalling it..."));
            this.createServiceUninstallCommand().doPureRun(context);
        }
        try {
            this.prepareServiceConfigFile(context);
            return null;
        }
        catch (IOException e) {
            ExceptionUtil.logError((Logger)this.LOG, (Throwable)e);
            return LauncherExitCode.ERROR;
        }
    }

    @Nullable
    protected LauncherExitCode afterServiceConfigured(@NotNull LauncherContextEx context) throws InitException {
        if (context == null) {
            BaseServiceSubCommand.$$$reportNull$$$0(7);
        }
        return null;
    }

    @Nullable
    protected LauncherExitCode afterServiceConfiguredForPrepareConfig(@NotNull LauncherContextEx context) {
        if (context == null) {
            BaseServiceSubCommand.$$$reportNull$$$0(8);
        }
        ConsoleLogger.system((String)this.getServiceConfigFile((AppConfigFiles)context.getAppFiles()).getAbsolutePath());
        return LauncherExitCode.OK;
    }

    @Nullable
    protected LauncherExitCode afterServiceConfiguredForInstall(@NotNull LauncherContextEx context) throws InitException {
        String serviceName;
        if (context == null) {
            BaseServiceSubCommand.$$$reportNull$$$0(9);
        }
        if (this.serviceExists(context, serviceName = this.getCurrentServiceName(context), false)) {
            if (context.getArguments().containsForceOption()) {
                this.createServiceUninstallCommand().doPureRun(context);
            } else {
                String serviceTypeName = this.getServiceTypeName();
                this.LOG.warn((Object)(StringUtil.capitalize((String)serviceTypeName) + " already exists, use \"" + "--force" + "\" option to reinstall the " + serviceTypeName));
                return LauncherExitCode.ILLEGAL_STATE;
            }
        }
        return null;
    }

    @NotNull
    protected abstract String getServiceNameName();

    @NotNull
    protected abstract String getServiceTypeName();

    @NotNull
    protected abstract BaseServiceSubCommand createServiceUninstallCommand();

    @NotNull
    protected final LauncherExitCode doPureRun(@NotNull LauncherContextEx context) throws InitException {
        if (context == null) {
            BaseServiceSubCommand.$$$reportNull$$$0(10);
        }
        LauncherExitCode launcherExitCode = super.doRun(context);
        if (launcherExitCode == null) {
            BaseServiceSubCommand.$$$reportNull$$$0(11);
        }
        return launcherExitCode;
    }

    @Override
    @NotNull
    protected BaseProcessBasedCommand.ExitCodeConverter createExitCodeConverter() {
        BaseProcessBasedCommand.ExitCodeConverter exitCodeConverter = new BaseProcessBasedCommand.ExitCodeConverter(){

            @Override
            @NotNull
            public LauncherExitCode toLauncherExitCode(int exitCode) {
                LauncherExitCode launcherExitCode = exitCode == BaseServiceSubCommand.this.getIllegalStateExitCodeValue() ? LauncherExitCode.ILLEGAL_STATE : DEFAULT.toLauncherExitCode(exitCode);
                if (launcherExitCode == null) {
                    1.$$$reportNull$$$0(0);
                }
                return launcherExitCode;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/ep/commands/BaseServiceSubCommand$1", "toLauncherExitCode"));
            }
        };
        if (exitCodeConverter == null) {
            BaseServiceSubCommand.$$$reportNull$$$0(12);
        }
        return exitCodeConverter;
    }

    protected abstract int getIllegalStateExitCodeValue();

    @Nullable
    private String getOldServiceName(@NotNull LauncherContext context) {
        File configFile;
        if (context == null) {
            BaseServiceSubCommand.$$$reportNull$$$0(13);
        }
        if (!(configFile = this.getServiceConfigFile((AppConfigFiles)context.getAppFiles())).isFile()) {
            return null;
        }
        try {
            return this.doGetOldServiceName(FileUtil.loadText((File)configFile));
        }
        catch (IOException e) {
            ExceptionUtil.logWarning((Logger)this.LOG, (String)("Failed to read old " + this.getServiceTypeName() + " " + this.getServiceNameName() + " from config file"), (Throwable)e);
            return null;
        }
    }

    @Nullable
    protected abstract String doGetOldServiceName(@NotNull String var1);

    @NotNull
    protected abstract String getCurrentServiceName(@NotNull LauncherContext var1);

    protected abstract boolean serviceExists(@NotNull LauncherContext var1, @NotNull String var2, boolean var3);

    private void prepareServiceConfigFile(@NotNull LauncherContext context) throws IOException {
        if (context == null) {
            BaseServiceSubCommand.$$$reportNull$$$0(14);
        }
        AppFilesEx appFiles = context.getAppFiles();
        this.doPrepareServiceConfigFile(appFiles.resolveLauncherConfigFile(this.getServiceConfigDistFileName()), this.getServiceConfigFile((AppConfigFiles)appFiles), context);
    }

    @NotNull
    protected abstract String getServiceConfigDistFileName();

    @NotNull
    public abstract File getServiceConfigFile(@NotNull AppConfigFiles var1);

    private void doPrepareServiceConfigFile(@NotNull Resource serviceDistConfigFile, @NotNull File serviceConfigFile, @NotNull LauncherContext context) throws IOException {
        if (serviceDistConfigFile == null) {
            BaseServiceSubCommand.$$$reportNull$$$0(15);
        }
        if (serviceConfigFile == null) {
            BaseServiceSubCommand.$$$reportNull$$$0(16);
        }
        if (context == null) {
            BaseServiceSubCommand.$$$reportNull$$$0(17);
        }
        String resultConfigText = this.prepareConfigText(FileUtil.loadText((URL)serviceDistConfigFile.getURL()), serviceConfigFile, context);
        if (!serviceConfigFile.isFile() || !resultConfigText.equals(FileUtil.loadText((File)serviceConfigFile))) {
            FileUtil.saveText((File)serviceConfigFile, (String)resultConfigText);
        }
    }

    @NotNull
    protected abstract String prepareConfigText(@NotNull String var1, @NotNull File var2, @NotNull LauncherContext var3) throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/BaseServiceSubCommand";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceDistConfigFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceConfigFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/BaseServiceSubCommand";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doPureRun";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createExitCodeConverter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureService";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "afterServiceConfigured";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "afterServiceConfiguredForPrepareConfig";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "afterServiceConfiguredForInstall";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doPureRun";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOldServiceName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "prepareServiceConfigFile";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doPrepareServiceConfigFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

