/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.BaseLauncherSubCommand;
import com.jetbrains.launcher.lock.AppLockFactory;
import com.jetbrains.launcher.lock.AppState;
import com.jetbrains.launcher.log.ConsoleLogger;
import com.jetbrains.launcher.log.LoggerMode;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LauncherPid
extends BaseLauncherSubCommand {
    @NotNull
    private static final String NAME = "pid";
    @NotNull
    private final Logger LOG = Logger.getLogger(LauncherPid.class);

    @NotNull
    public String getName() {
        if (NAME == null) {
            LauncherPid.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @Override
    @NotNull
    protected LoggerMode getLoggerMode(@NotNull Arguments args) {
        if (args == null) {
            LauncherPid.$$$reportNull$$$0(1);
        }
        LoggerMode loggerMode = LoggerMode.CONSOLE_ERROR_ONLY;
        if (loggerMode == null) {
            LauncherPid.$$$reportNull$$$0(2);
        }
        return loggerMode;
    }

    @Override
    @NotNull
    protected LauncherExitCode doRun(@NotNull LauncherContextEx context) throws InitException {
        AppState appState;
        if (context == null) {
            LauncherPid.$$$reportNull$$$0(3);
        }
        if ((appState = context.getAppState()) == null) {
            this.LOG.error((Object)(context.getAppConfig().getAppName().getCapitalizedName() + " launcher is not running"));
            LauncherExitCode launcherExitCode = LauncherExitCode.ILLEGAL_STATE;
            if (launcherExitCode == null) {
                LauncherPid.$$$reportNull$$$0(4);
            }
            return launcherExitCode;
        }
        Integer launcherPid = AppLockFactory.createLockChecker(context).getLauncherPid();
        if (launcherPid == null) {
            this.LOG.error((Object)"Failed to determine launcher PID");
            LauncherExitCode launcherExitCode = LauncherExitCode.ERROR;
            if (launcherExitCode == null) {
                LauncherPid.$$$reportNull$$$0(5);
            }
            return launcherExitCode;
        }
        ConsoleLogger.system((String)String.valueOf(launcherPid));
        LauncherExitCode launcherExitCode = LauncherExitCode.OK;
        if (launcherExitCode == null) {
            LauncherPid.$$$reportNull$$$0(6);
        }
        return launcherExitCode;
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            LauncherPid.$$$reportNull$$$0(7);
        }
        if (context == null) {
            LauncherPid.$$$reportNull$$$0(8);
        }
        printer.print(this.getFullName(), "prints " + context.getAppConfig().getAppName().getName() + " launcher process ID");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/LauncherPid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/LauncherPid";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerMode";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerMode";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

