/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.AppName;
import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.Destroyer;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.Initializer;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.ProcessContext;
import com.jetbrains.launcher.Status;
import com.jetbrains.launcher.StatusDescriptor;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.MainEmbedded;
import com.jetbrains.launcher.ep.commands.BaseSoftModeSupportingCommand;
import com.jetbrains.launcher.ep.commands.DoStart;
import com.jetbrains.launcher.ep.commands.Run;
import com.jetbrains.launcher.log.LoggerMode;
import com.jetbrains.launcher.run.AgentDiagnosticFacade;
import com.jetbrains.launcher.run.AgentFacade;
import com.jetbrains.launcher.run.AgentRuntimeHelper;
import com.jetbrains.launcher.run.UpToDateLauncherContext;
import com.jetbrains.launcher.util.DevUtil;
import com.jetbrains.launcher.util.ExceptionUtil;
import com.jetbrains.launcher.util.LauncherExecutor;
import com.jetbrains.launcher.util.LauncherUtil;
import com.jetbrains.launcher.util.ProcessUtil;
import com.jetbrains.launcher.util.TimeoutException;
import com.jetbrains.launcher.util.WaitFor;
import com.jetbrains.launcher.util.java.InvalidJvmOptionException;
import com.jetbrains.launcher.util.process.ConsoleProcessOutputWriter;
import com.jetbrains.launcher.util.process.ProcessHandler;
import com.jetbrains.launcher.util.process.ProcessOutputListener;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Start
extends BaseSoftModeSupportingCommand {
    @NotNull
    public static final String NAME = "start";
    @NotNull
    private final Logger LOG = Logger.getLogger(Start.class);

    @NotNull
    public String getName() {
        if (NAME == null) {
            Start.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @Override
    @NotNull
    public String getOrderId() {
        if ("c" == null) {
            Start.$$$reportNull$$$0(1);
        }
        return "c";
    }

    @Override
    @NotNull
    protected LoggerMode getLoggerMode(@NotNull Arguments args) {
        if (args == null) {
            Start.$$$reportNull$$$0(2);
        }
        LoggerMode loggerMode = LoggerMode.LAUNCHER;
        if (loggerMode == null) {
            Start.$$$reportNull$$$0(3);
        }
        return loggerMode;
    }

    @Override
    @NotNull
    protected LauncherExitCode doRun(@NotNull LauncherContextEx context) throws InitException {
        LauncherExitCode code;
        if (context == null) {
            Start.$$$reportNull$$$0(4);
        }
        if ((code = Run.checkState(context, context.getAppConfig().getAppName(), this.LOG)) != null) {
            LauncherExitCode launcherExitCode = code;
            if (launcherExitCode == null) {
                Start.$$$reportNull$$$0(5);
            }
            return launcherExitCode;
        }
        Run.setConsoleCtrlCloseHandlerIfNeeded(context, this.LOG);
        UpToDateLauncherContext upToDateContext = new UpToDateLauncherContext(context);
        if (context.getArguments().isEmbeddedMode()) {
            LauncherExitCode launcherExitCode = Start.doStart(upToDateContext, this.LOG, new EmbeddedLauncherProcess(context));
            if (launcherExitCode == null) {
                Start.$$$reportNull$$$0(6);
            }
            return launcherExitCode;
        }
        LauncherExitCode launcherExitCode = Start.doStart(upToDateContext, this.LOG, new ExternalLauncherProcess(upToDateContext));
        if (launcherExitCode == null) {
            Start.$$$reportNull$$$0(7);
        }
        return launcherExitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected static LauncherExitCode doStart(final @NotNull UpToDateLauncherContext context, final @NotNull Logger log, final @NotNull LauncherProcess launcherProcess) throws InitException {
        LauncherExitCode launcherExitCode;
        if (context == null) {
            Start.$$$reportNull$$$0(8);
        }
        if (log == null) {
            Start.$$$reportNull$$$0(9);
        }
        if (launcherProcess == null) {
            Start.$$$reportNull$$$0(10);
        }
        AppName appName = context.getAppConfig().getAppName();
        try {
            launcherProcess.start();
        }
        catch (Exception e) {
            log.error((Object)("Failed to start " + appName.getName() + " launcher: " + e));
            LauncherExitCode launcherExitCode2 = LauncherExitCode.ERROR;
            if (launcherExitCode2 == null) {
                Start.$$$reportNull$$$0(11);
            }
            return launcherExitCode2;
        }
        launcherProcess.beforeWaiting();
        final boolean isDevMode = DevUtil.isDevMode();
        long startTimeoutSeconds = Start.isSoft(context.getArguments()) ? Integer.MAX_VALUE : (long)context.getAppConfig().getStartTimeoutSeconds();
        try {
            new WaitFor<RuntimeException>(Long.valueOf(startTimeoutSeconds * 1000L)){

                protected boolean condition() {
                    return !launcherProcess.isAlive() || Start.isAppRunning(context, log, isDevMode);
                }
            };
        }
        catch (TimeoutException e) {
            launcherProcess.onTimeoutException();
            log.error((Object)(appName.getCapitalizedName() + " failed to start in " + startTimeoutSeconds + " seconds, but is still starting"));
            Start.dumpThreadsIfPossible(context.createAgentFacade(), log);
            LauncherExitCode launcherExitCode3 = LauncherExitCode.NO;
            LauncherExitCode launcherExitCode4 = launcherExitCode3;
            if (launcherExitCode4 == null) {
                Start.$$$reportNull$$$0(12);
            }
            return launcherExitCode4;
        }
        catch (InterruptedException e) {
            log.debug((Object)"Interrupted");
            LauncherExitCode launcherExitCode5 = LauncherExitCode.INTERRUPTED;
            LauncherExitCode launcherExitCode6 = launcherExitCode5;
            if (launcherExitCode6 == null) {
                Start.$$$reportNull$$$0(13);
            }
            return launcherExitCode6;
        }
        finally {
            launcherProcess.afterWaiting();
        }
        try {
            int launcherExitCode7 = launcherProcess.getExitCode();
            log.error((Object)(appName.getCapitalizedName() + " failed to start"));
            log.debug((Object)("Launcher exit code: " + launcherExitCode7));
            launcherExitCode = LauncherUtil.getLauncherErrorExitCode(launcherExitCode7);
        }
        catch (IllegalThreadStateException e) {
            log.info((Object)(appName.getCapitalizedName() + " is running"));
            LauncherExitCode launcherExitCode8 = LauncherExitCode.OK;
            if (launcherExitCode8 == null) {
                Start.$$$reportNull$$$0(15);
            }
            return launcherExitCode8;
        }
        if (launcherExitCode == null) {
            Start.$$$reportNull$$$0(14);
        }
        return launcherExitCode;
    }

    protected static void dumpThreadsIfPossible(@NotNull AgentFacade agentFacade, @NotNull Logger log) {
        AgentDiagnosticFacade diagnosticFacade;
        if (agentFacade == null) {
            Start.$$$reportNull$$$0(16);
        }
        if (log == null) {
            Start.$$$reportNull$$$0(17);
        }
        if ((diagnosticFacade = agentFacade.getDiagnosticFacade()) != null) {
            try {
                File file = diagnosticFacade.dumpThreadsToFile();
                log.info((Object)("Threads were dumped to the file: " + file.getAbsolutePath()));
            }
            catch (IOException e) {
                ExceptionUtil.logWarning((Logger)log, (String)"Failed to dump threads", (Throwable)e);
            }
        }
    }

    protected static boolean isAppRunning(@NotNull UpToDateLauncherContext context, @NotNull Logger log, boolean logStatus) {
        if (context == null) {
            Start.$$$reportNull$$$0(18);
        }
        if (log == null) {
            Start.$$$reportNull$$$0(19);
        }
        try {
            StatusDescriptor status = context.getStatus(false);
            if (logStatus) {
                log.trace((Object)("Status: " + status.asString()));
            }
            return status.is(Status.RUNNING);
        }
        catch (InitException e) {
            ExceptionUtil.logWarning((Logger)log, (String)("Failed to get " + context.getAppConfig().getAppName().getName() + " status"), (Throwable)e);
            return false;
        }
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            Start.$$$reportNull$$$0(20);
        }
        if (context == null) {
            Start.$$$reportNull$$$0(21);
        }
        printer.print(NAME, "starts " + context.getAppConfig().getAppName().getName() + " in background, " + this.getComplexCommandUsageText());
    }

    @Override
    public void printStandaloneUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            Start.$$$reportNull$$$0(22);
        }
        if (context == null) {
            Start.$$$reportNull$$$0(23);
        }
        String name = context.getAppConfig().getAppName().getName();
        printer.print(NAME, "starts " + name + " in background");
        printer.print("start soft", "starts " + name + " in background softly (timeout is not applied in this case)");
        if (context.getArguments().isJavaApplication()) {
            Run.printAdHocJvmOptionsInfo();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/Start";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 4: 
            case 8: 
            case 18: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherProcess";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentFacade";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderId";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/Start";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerMode";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "doStart";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerMode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doStart";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "dumpThreadsIfPossible";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isAppRunning";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "printStandaloneUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmbeddedLauncherProcess
    implements LauncherProcess {
        @NotNull
        private final Thread myThread;
        @Nullable
        private volatile Integer myExitCode;

        public EmbeddedLauncherProcess(final @NotNull LauncherContext context) {
            if (context == null) {
                EmbeddedLauncherProcess.$$$reportNull$$$0(0);
            }
            final ProcessContext parentContext = ProcessContext.get();
            final Destroyer parentDestroyer = Destroyer.get();
            this.myThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    ProcessContext.initChildContext((ProcessContext)parentContext);
                    final Arguments args = context.getArguments();
                    final String[] newCmdLine = LauncherUtil.prepareCommand("do", args.getCmdLine());
                    MainEmbedded.initThreadPrefix(context.getAppFiles().getAppHome(), newCmdLine);
                    Destroyer.initChildDestroyer((Destroyer)parentDestroyer);
                    EmbeddedLauncherProcess.this.myExitCode = Initializer.runWithContext((Initializer.LauncherProcess)new Initializer.LauncherProcess(){

                        @NotNull
                        public LauncherExitCode run() {
                            LauncherExitCode launcherExitCode = new DoStart().run(args.withCmdLine(newCmdLine));
                            if (launcherExitCode == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return launcherExitCode;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/ep/commands/Start$EmbeddedLauncherProcess$1$1", "run"));
                        }
                    }).getValue();
                }
            }, "main");
        }

        @Override
        public void start() {
            this.myThread.start();
        }

        @Override
        public boolean isAlive() {
            return this.myThread.isAlive();
        }

        @Override
        public int getExitCode() throws IllegalThreadStateException {
            Integer exitCode = this.myExitCode;
            if (exitCode == null) {
                throw new IllegalThreadStateException();
            }
            return exitCode;
        }

        @Override
        public void beforeWaiting() {
        }

        @Override
        public void onTimeoutException() {
        }

        @Override
        public void afterWaiting() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/launcher/ep/commands/Start$EmbeddedLauncherProcess", "<init>"));
        }
    }

    private static class ExternalLauncherProcess
    implements LauncherProcess {
        @NotNull
        private final Logger LOG;
        @NotNull
        private final UpToDateLauncherContext myContext;
        @NotNull
        private final AgentRuntimeHelper myAgentRuntimeHelper;
        @Nullable
        private Process myProcess;
        @Nullable
        private ProcessHandler myProcessHandler;

        private ExternalLauncherProcess(@NotNull UpToDateLauncherContext context) {
            if (context == null) {
                ExternalLauncherProcess.$$$reportNull$$$0(0);
            }
            this.LOG = Logger.getLogger(ExternalLauncherProcess.class);
            this.myContext = context;
            this.myAgentRuntimeHelper = new AgentRuntimeHelper(context);
        }

        @Override
        public void start() throws IOException, InvalidJvmOptionException {
            String[] command = LauncherUtil.prepareCommand("do", this.myContext.getArguments().getCmdLine());
            this.myProcess = new LauncherExecutor(this.myContext).startLauncher(command);
        }

        @Override
        public boolean isAlive() {
            return this.myProcess != null && ProcessUtil.isAlive((Process)this.myProcess);
        }

        @Override
        public int getExitCode() throws IllegalThreadStateException {
            Process process = this.myProcess;
            if (process == null) {
                throw new IllegalThreadStateException();
            }
            return process.exitValue();
        }

        @Override
        public void beforeWaiting() {
            if (this.myProcess == null) {
                throw new IllegalStateException();
            }
            this.myProcessHandler = ProcessHandler.builder((Process)this.myProcess).withListener((ProcessOutputListener)new ConsoleProcessOutputWriter()).onDestroy(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String appName = ExternalLauncherProcess.this.myContext.getAppConfig().getAppName().getName();
                    ExternalLauncherProcess.this.LOG.info((Object)("Destroying " + appName + " process..."));
                    try {
                        ExternalLauncherProcess.this.myProcess.destroy();
                        if (ExternalLauncherProcess.this.myContext.createAgentFacade().stopOrKill()) {
                            ExternalLauncherProcess.this.LOG.info((Object)("Launcher has terminated " + appName + " process"));
                            ExternalLauncherProcess.this.LOG.info((Object)"Launcher is exiting");
                        }
                    }
                    finally {
                        ExternalLauncherProcess.this.myAgentRuntimeHelper.afterRun();
                    }
                }
            }).build();
            this.myProcessHandler.start();
        }

        @Override
        public void onTimeoutException() {
            if (this.myProcessHandler != null) {
                this.myProcessHandler.cancel();
            }
        }

        @Override
        public void afterWaiting() {
            if (this.myProcessHandler != null) {
                this.myProcessHandler.finish();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/launcher/ep/commands/Start$ExternalLauncherProcess", "<init>"));
        }
    }

    protected static interface LauncherProcess {
        public void start() throws IOException, InvalidJvmOptionException;

        public boolean isAlive();

        public int getExitCode() throws IllegalThreadStateException;

        public void beforeWaiting();

        public void onTimeoutException();

        public void afterWaiting();
    }
}

