/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.LauncherArgumentsParser;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.SystemInfo;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.Commands;
import com.jetbrains.launcher.ep.commands.BaseCommand;
import com.jetbrains.launcher.log.ConsoleLogger;
import com.jetbrains.launcher.log.LoggerMode;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Usage
extends BaseCommand {
    @NotNull
    public static final String NAME = "help";
    @Nullable
    private final Command myBaseCommand;
    @Nullable
    private final String myUnknownCommandName;
    private final boolean myWrongUsage;

    public Usage() {
        this(null, null, false);
    }

    public Usage(@Nullable Command baseCommand, @Nullable String unknownCommandName, boolean wrongUsage) {
        this.myBaseCommand = baseCommand;
        this.myUnknownCommandName = unknownCommandName;
        this.myWrongUsage = wrongUsage;
    }

    @NotNull
    public String getName() {
        if (NAME == null) {
            Usage.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @Override
    @NotNull
    public String getOrderId() {
        if ("l" == null) {
            Usage.$$$reportNull$$$0(1);
        }
        return "l";
    }

    @Override
    @NotNull
    protected LoggerMode getLoggerMode(@NotNull Arguments args) {
        if (args == null) {
            Usage.$$$reportNull$$$0(2);
        }
        LoggerMode loggerMode = LoggerMode.CONSOLE_ERROR_ONLY;
        if (loggerMode == null) {
            Usage.$$$reportNull$$$0(3);
        }
        return loggerMode;
    }

    @Override
    protected boolean readsFromOrWritesToLogsFolder() {
        return false;
    }

    @Override
    @NotNull
    protected LauncherExitCode doRun(@NotNull LauncherContextEx context) {
        if (context == null) {
            Usage.$$$reportNull$$$0(4);
        }
        if (this.myWrongUsage) {
            if (this.myUnknownCommandName != null) {
                Usage.printUnknownCommand((this.myBaseCommand == null ? "" : this.myBaseCommand.getFullName() + " ") + this.myUnknownCommandName);
            }
            if (this.myBaseCommand == null) {
                Usage.printWholeUsage(context);
            } else {
                Usage.printCommandUsage(this.myBaseCommand, context);
            }
            LauncherExitCode launcherExitCode = LauncherExitCode.WRONG_USAGE;
            if (launcherExitCode == null) {
                Usage.$$$reportNull$$$0(5);
            }
            return launcherExitCode;
        }
        Arguments args = context.getArguments();
        String commandName = args.getSubCommandName(1);
        if (commandName == null) {
            Usage.printWholeUsage(context);
            if (args.containsDevOption()) {
                ConsoleLogger.error((String)"Use \"--debug\" option to print debug information to the console");
                ConsoleLogger.error((String)"Use \"--quiet\" option to print nothing but errors and important messages to the console");
                ConsoleLogger.error();
            }
            LauncherExitCode launcherExitCode = LauncherExitCode.OK;
            if (launcherExitCode == null) {
                Usage.$$$reportNull$$$0(6);
            }
            return launcherExitCode;
        }
        Command command = Commands.findCommand(commandName, Commands.getAllCommands(), args);
        if (command == null) {
            Usage.printUnknownCommand(commandName);
            LauncherExitCode launcherExitCode = LauncherExitCode.ERROR;
            if (launcherExitCode == null) {
                Usage.$$$reportNull$$$0(7);
            }
            return launcherExitCode;
        }
        int i = 1;
        while (true) {
            String subCommandName;
            if ((subCommandName = args.getSubCommandName(++i)) == null) {
                Usage.printCommandUsage(command, context);
                LauncherExitCode launcherExitCode = LauncherExitCode.OK;
                if (launcherExitCode == null) {
                    Usage.$$$reportNull$$$0(8);
                }
                return launcherExitCode;
            }
            Command subCommand = command.findSubCommand(subCommandName, args);
            if (subCommand == null) {
                Usage.printUnknownCommand(command.getFullName() + " " + subCommandName);
                LauncherExitCode launcherExitCode = LauncherExitCode.ERROR;
                if (launcherExitCode == null) {
                    Usage.$$$reportNull$$$0(9);
                }
                return launcherExitCode;
            }
            command = subCommand;
        }
    }

    @Override
    @Nullable
    public LauncherArgumentsParser.State next(@NotNull String arg) {
        if (arg == null) {
            Usage.$$$reportNull$$$0(10);
        }
        return Commands.findCommand(arg, Commands.getAllCommands(), null);
    }

    @Override
    @NotNull
    public Command findSubCommand(@NotNull String subCommandName, @NotNull Arguments args) {
        if (subCommandName == null) {
            Usage.$$$reportNull$$$0(11);
        }
        if (args == null) {
            Usage.$$$reportNull$$$0(12);
        }
        Usage usage = this;
        if (usage == null) {
            Usage.$$$reportNull$$$0(13);
        }
        return usage;
    }

    private static void printUnknownCommand(@NotNull String commandName) {
        if (commandName == null) {
            Usage.$$$reportNull$$$0(14);
        }
        ConsoleLogger.error((String)("Unknown command: " + commandName));
    }

    private static void printWholeUsage(@NotNull LauncherContext context) {
        if (context == null) {
            Usage.$$$reportNull$$$0(15);
        }
        ConsoleLogger.error();
        ConsoleLogger.error((String)"Usage:");
        ConsoleLogger.error((String)("  " + Usage.getLauncherScript(context) + " <command>"));
        ConsoleLogger.error();
        ConsoleLogger.error((String)"<command> can be one of the following:");
        ConsoleLogger.error();
        Usage.printCommands(Usage.createUsagePrinter(), Commands.getAllCommands(), context);
    }

    protected static void printCommands(@NotNull Command.UsagePrinter printer, @NotNull List<? extends Command> commands, @NotNull LauncherContext context) {
        if (printer == null) {
            Usage.$$$reportNull$$$0(16);
        }
        if (commands == null) {
            Usage.$$$reportNull$$$0(17);
        }
        if (context == null) {
            Usage.$$$reportNull$$$0(18);
        }
        Command.CommandType type = context.getArguments().containsDevOption() ? Command.CommandType.DEV_COMMAND : Command.CommandType.USER_COMMAND;
        Usage.printCommands(printer, commands, type, context);
    }

    protected static void printCommands(@NotNull Command.UsagePrinter printer, @NotNull List<? extends Command> commands, @NotNull Command.CommandType type, @NotNull LauncherContext context) {
        if (printer == null) {
            Usage.$$$reportNull$$$0(19);
        }
        if (commands == null) {
            Usage.$$$reportNull$$$0(20);
        }
        if (type == null) {
            Usage.$$$reportNull$$$0(21);
        }
        if (context == null) {
            Usage.$$$reportNull$$$0(22);
        }
        Arguments args = context.getArguments();
        for (Command command : commands) {
            if (command.getType(args) != type || !command.isAvailable(args)) continue;
            command.printUsage(printer, context);
        }
    }

    private static void printCommandUsage(@NotNull Command command, @NotNull LauncherContext context) {
        if (command == null) {
            Usage.$$$reportNull$$$0(23);
        }
        if (context == null) {
            Usage.$$$reportNull$$$0(24);
        }
        if (command.getType(context.getArguments()) == Command.CommandType.SYSTEM_COMMAND) {
            ConsoleLogger.error((String)"This command should not be run manually");
        } else {
            ConsoleLogger.error();
            ConsoleLogger.error((String)("Usage of the \"" + command.getFullName() + "\" command:"));
            ConsoleLogger.error();
            command.printStandaloneUsage(Usage.createUsagePrinter(), context);
        }
    }

    @NotNull
    private static String getLauncherScript(@NotNull LauncherContext context) {
        if (context == null) {
            Usage.$$$reportNull$$$0(25);
        }
        StringBuilder sb = new StringBuilder();
        if (!SystemInfo.isWindows) {
            sb.append("/bin/sh ");
        }
        sb.append(context.getAppFiles().getAppScriptFile().getAbsolutePath());
        String string = sb.toString();
        if (string == null) {
            Usage.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    private static Command.UsagePrinter createUsagePrinter() {
        Command.UsagePrinter usagePrinter = new Command.UsagePrinter(){

            public void print(@NotNull String command, @NotNull String description) {
                if (command == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (description == null) {
                    1.$$$reportNull$$$0(1);
                }
                ConsoleLogger.error((String)("  " + command));
                ConsoleLogger.error((String)("    " + description));
                ConsoleLogger.error();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "command";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "description";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/launcher/ep/commands/Usage$1";
                objectArray[2] = "print";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (usagePrinter == null) {
            Usage.$$$reportNull$$$0(27);
        }
        return usagePrinter;
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            Usage.$$$reportNull$$$0(28);
        }
        if (context == null) {
            Usage.$$$reportNull$$$0(29);
        }
        printer.print(NAME, "prints usage text");
        printer.print("help <command name>", "prints usage text for the specified command");
    }

    @Override
    public void printStandaloneUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            Usage.$$$reportNull$$$0(30);
        }
        if (context == null) {
            Usage.$$$reportNull$$$0(31);
        }
        this.printUsage(printer, context);
        ConsoleLogger.error((String)"Use \"--dev\" option to print usage text for the developer commands");
        ConsoleLogger.error();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/Usage";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 4: 
            case 15: 
            case 18: 
            case 22: 
            case 24: 
            case 25: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subCommandName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 16: 
            case 19: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderId";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/Usage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerMode";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findSubCommand";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherScript";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsagePrinter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerMode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "next";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findSubCommand";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "printUnknownCommand";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "printWholeUsage";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "printCommands";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "printCommandUsage";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLauncherScript";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "printStandaloneUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

