/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.lock;

import com.jetbrains.launcher.AppFiles;
import com.jetbrains.launcher.AppFixedFiles;
import com.jetbrains.launcher.InitAction;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.ThrowableRunnable;
import com.jetbrains.launcher.lock.AppLock;
import com.jetbrains.launcher.lock.AppState;
import com.jetbrains.launcher.lock.CannotAcquireAppLockException;
import com.jetbrains.launcher.lock.CompositeAppLock;
import com.jetbrains.launcher.lock.LauncherAwareAppLock;
import com.jetbrains.launcher.lock.LauncherAwareAppLockChecker;
import com.jetbrains.launcher.lock.LauncherAwareAppLockCheckerImpl;
import com.jetbrains.launcher.lock.LauncherAwareAppLockImpl;
import com.jetbrains.launcher.lock.NoLock;
import com.jetbrains.launcher.run.LauncherContextListener;
import com.jetbrains.launcher.run.UpToDateLauncherContext;
import com.jetbrains.launcher.util.TimeoutException;
import com.jetbrains.launcher.util.WaitFor;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public abstract class AppLockFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static LauncherExitCode withLock(@NotNull AppLock appLock, @NotNull AppState state, @NotNull InitAction action) throws InitException, CannotAcquireAppLockException {
        if (appLock == null) {
            AppLockFactory.$$$reportNull$$$0(0);
        }
        if (state == null) {
            AppLockFactory.$$$reportNull$$$0(1);
        }
        if (action == null) {
            AppLockFactory.$$$reportNull$$$0(2);
        }
        appLock.lock(state);
        LauncherExitCode launcherExitCode = action.run();
        LauncherExitCode launcherExitCode2 = launcherExitCode;
        if (launcherExitCode2 == null) {
            AppLockFactory.$$$reportNull$$$0(3);
        }
        return launcherExitCode2;
        finally {
            appLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static LauncherExitCode withLock(final @NotNull AppLock appLock, final @NotNull AppState state, @NotNull InitAction action, long timeoutMillis) throws InitException, CannotAcquireAppLockException {
        if (appLock == null) {
            AppLockFactory.$$$reportNull$$$0(4);
        }
        if (state == null) {
            AppLockFactory.$$$reportNull$$$0(5);
        }
        if (action == null) {
            AppLockFactory.$$$reportNull$$$0(6);
        }
        try {
            new WaitFor<RuntimeException>(Long.valueOf(timeoutMillis)){

                protected boolean condition() {
                    try {
                        appLock.lock(state);
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            };
        }
        catch (TimeoutException e) {
            throw new CannotAcquireAppLockException("Failed to acquire lock: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        LauncherExitCode launcherExitCode = action.run();
        LauncherExitCode launcherExitCode2 = launcherExitCode;
        if (launcherExitCode2 == null) {
            AppLockFactory.$$$reportNull$$$0(7);
        }
        return launcherExitCode2;
        finally {
            appLock.unlock();
        }
    }

    @NotNull
    public static LauncherAwareAppLockChecker createLockChecker(@NotNull LauncherContext context) {
        if (context == null) {
            AppLockFactory.$$$reportNull$$$0(8);
        }
        LauncherAwareAppLockChecker launcherAwareAppLockChecker = AppLockFactory.createLockChecker(context.getAppFiles().getLauncherLogsFolder());
        if (launcherAwareAppLockChecker == null) {
            AppLockFactory.$$$reportNull$$$0(9);
        }
        return launcherAwareAppLockChecker;
    }

    @NotNull
    public static LauncherAwareAppLockChecker createLockChecker(@NotNull File launcherLogsFolder) {
        if (launcherLogsFolder == null) {
            AppLockFactory.$$$reportNull$$$0(10);
        }
        LauncherAwareAppLockChecker launcherAwareAppLockChecker = AppLockFactory.createLockCheckerImpl(launcherLogsFolder);
        if (launcherAwareAppLockChecker == null) {
            AppLockFactory.$$$reportNull$$$0(11);
        }
        return launcherAwareAppLockChecker;
    }

    @NotNull
    public static LauncherAwareAppLock createLock(@NotNull AppFiles appFiles) {
        if (appFiles == null) {
            AppLockFactory.$$$reportNull$$$0(12);
        }
        LauncherAwareAppLockImpl launcherAwareAppLockImpl = AppLockFactory.createLockImpl(appFiles);
        if (launcherAwareAppLockImpl == null) {
            AppLockFactory.$$$reportNull$$$0(13);
        }
        return launcherAwareAppLockImpl;
    }

    @NotNull
    public static LauncherAwareAppLock createLock(@NotNull File launcherLogsFolder, @NotNull AppFixedFiles appFixedFiles) {
        if (launcherLogsFolder == null) {
            AppLockFactory.$$$reportNull$$$0(14);
        }
        if (appFixedFiles == null) {
            AppLockFactory.$$$reportNull$$$0(15);
        }
        LauncherAwareAppLockImpl launcherAwareAppLockImpl = AppLockFactory.createLockImpl(launcherLogsFolder, appFixedFiles);
        if (launcherAwareAppLockImpl == null) {
            AppLockFactory.$$$reportNull$$$0(16);
        }
        return launcherAwareAppLockImpl;
    }

    @NotNull
    public static LauncherAwareAppLock createLock(@NotNull UpToDateLauncherContext context) {
        if (context == null) {
            AppLockFactory.$$$reportNull$$$0(17);
        }
        final LauncherAwareAppLockImpl lockImpl = AppLockFactory.createLockImpl((AppFiles)context.getAppFiles());
        context.addListener(new LauncherContextListener(){

            @Override
            public void launcherContextChanged(@NotNull LauncherContext newContext) throws InitException {
                if (newContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                lockImpl.updateLock(newContext.getAppFiles().getLauncherLogsFolder(), new ThrowableRunnable<InitException>(){

                    public void run() {
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "com/jetbrains/launcher/lock/AppLockFactory$2", "launcherContextChanged"));
            }
        });
        LauncherAwareAppLockImpl launcherAwareAppLockImpl = lockImpl;
        if (launcherAwareAppLockImpl == null) {
            AppLockFactory.$$$reportNull$$$0(18);
        }
        return launcherAwareAppLockImpl;
    }

    @NotNull
    public static AppLock createCompositeLock(@NotNull AppLock firstLock, @NotNull AppLock secondLock) {
        if (firstLock == null) {
            AppLockFactory.$$$reportNull$$$0(19);
        }
        if (secondLock == null) {
            AppLockFactory.$$$reportNull$$$0(20);
        }
        CompositeAppLock compositeAppLock = new CompositeAppLock(firstLock, secondLock);
        if (compositeAppLock == null) {
            AppLockFactory.$$$reportNull$$$0(21);
        }
        return compositeAppLock;
    }

    @NotNull
    public static AppLock createNoLock() {
        NoLock noLock = new NoLock();
        if (noLock == null) {
            AppLockFactory.$$$reportNull$$$0(22);
        }
        return noLock;
    }

    @NotNull
    private static LauncherAwareAppLockImpl createLockImpl(@NotNull AppFiles appFiles) {
        if (appFiles == null) {
            AppLockFactory.$$$reportNull$$$0(23);
        }
        LauncherAwareAppLockImpl launcherAwareAppLockImpl = AppLockFactory.createLockImpl(appFiles.getLauncherLogsFolder(), (AppFixedFiles)appFiles);
        if (launcherAwareAppLockImpl == null) {
            AppLockFactory.$$$reportNull$$$0(24);
        }
        return launcherAwareAppLockImpl;
    }

    @NotNull
    private static LauncherAwareAppLockImpl createLockImpl(@NotNull File launcherLogsFolder, @NotNull AppFixedFiles appFixedFiles) {
        if (launcherLogsFolder == null) {
            AppLockFactory.$$$reportNull$$$0(25);
        }
        if (appFixedFiles == null) {
            AppLockFactory.$$$reportNull$$$0(26);
        }
        LauncherAwareAppLockImpl launcherAwareAppLockImpl = new LauncherAwareAppLockImpl(launcherLogsFolder, appFixedFiles);
        if (launcherAwareAppLockImpl == null) {
            AppLockFactory.$$$reportNull$$$0(27);
        }
        return launcherAwareAppLockImpl;
    }

    @NotNull
    private static LauncherAwareAppLockChecker createLockCheckerImpl(@NotNull File launcherLogsFolder) {
        if (launcherLogsFolder == null) {
            AppLockFactory.$$$reportNull$$$0(28);
        }
        LauncherAwareAppLockCheckerImpl launcherAwareAppLockCheckerImpl = new LauncherAwareAppLockCheckerImpl(launcherLogsFolder);
        if (launcherAwareAppLockCheckerImpl == null) {
            AppLockFactory.$$$reportNull$$$0(29);
        }
        return launcherAwareAppLockCheckerImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appLock";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/lock/AppLockFactory";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 14: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherLogsFolder";
                break;
            }
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFiles";
                break;
            }
            case 15: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFixedFiles";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstLock";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/lock/AppLockFactory";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withLock";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createLockChecker";
                break;
            }
            case 13: 
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createLock";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeLock";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createNoLock";
                break;
            }
            case 24: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createLockImpl";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createLockCheckerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withLock";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 29: {
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createLockChecker";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createLock";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createCompositeLock";
                break;
            }
            case 23: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createLockImpl";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createLockCheckerImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

