/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.lock;

import com.jetbrains.launcher.Destroyer;
import com.jetbrains.launcher.DestroyerStep;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.Static;
import com.jetbrains.launcher.ThrowableRunnable;
import com.jetbrains.launcher.lock.AppState;
import com.jetbrains.launcher.lock.CannotAcquireAppLockException;
import com.jetbrains.launcher.lock.UpdatableAppLock;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EmbeddedAppLock
implements UpdatableAppLock<File> {
    @NotNull
    private static final String LOCK_IS_ALREADY_ACQUIRED_ERROR_TEXT = "Embedded lock is already acquired by another embedded process";
    @Static
    @NotNull
    private static final ConcurrentHashMap<File, AppState> LOCKS = new ConcurrentHashMap();
    @NotNull
    private File myFile;
    @Nullable
    private DestroyerStep myDestroyerStep;

    EmbeddedAppLock(@NotNull File file) {
        if (file == null) {
            EmbeddedAppLock.$$$reportNull$$$0(0);
        }
        this.myFile = file;
    }

    @Override
    public synchronized void lock(@NotNull AppState state) throws InitException, CannotAcquireAppLockException {
        if (state == null) {
            EmbeddedAppLock.$$$reportNull$$$0(1);
        }
        DestroyerStep destroyerStep = Destroyer.get().addStep(new Runnable(){

            @Override
            public void run() {
                EmbeddedAppLock.this.unlock();
            }
        });
        if (!EmbeddedAppLock.tryLock(state, this.myFile)) {
            destroyerStep.remove();
            throw new CannotAcquireAppLockException(LOCK_IS_ALREADY_ACQUIRED_ERROR_TEXT);
        }
        this.myDestroyerStep = destroyerStep;
    }

    @Override
    public synchronized void unlock() {
        EmbeddedAppLock.doRelease(this.myFile);
        if (this.myDestroyerStep != null) {
            this.myDestroyerStep.remove();
            this.myDestroyerStep = null;
        }
    }

    @Override
    public synchronized boolean isLocked() throws InitException {
        return LOCKS.containsKey(this.myFile);
    }

    @Override
    @Nullable
    public synchronized AppState getState() {
        return LOCKS.get(this.myFile);
    }

    @Override
    public synchronized void updateLock(@NotNull File newFile, @NotNull ThrowableRunnable<InitException> innerAction) throws InitException {
        if (newFile == null) {
            EmbeddedAppLock.$$$reportNull$$$0(2);
        }
        if (innerAction == null) {
            EmbeddedAppLock.$$$reportNull$$$0(3);
        }
        if (newFile.equals(this.myFile)) {
            return;
        }
        AppState state = this.getState();
        if (state == null) {
            innerAction.run();
            this.myFile = newFile;
            return;
        }
        if (!EmbeddedAppLock.tryLock(state, newFile)) {
            throw new InitException("Failed to change embedded lock: " + newFile.getAbsolutePath() + ": " + LOCK_IS_ALREADY_ACQUIRED_ERROR_TEXT);
        }
        try {
            innerAction.run();
        }
        catch (InitException e) {
            EmbeddedAppLock.doRelease(newFile);
            throw e;
        }
        EmbeddedAppLock.doRelease(this.myFile);
        this.myFile = newFile;
    }

    private static boolean tryLock(@NotNull AppState state, @NotNull File file) {
        if (state == null) {
            EmbeddedAppLock.$$$reportNull$$$0(4);
        }
        if (file == null) {
            EmbeddedAppLock.$$$reportNull$$$0(5);
        }
        return LOCKS.putIfAbsent(file, state) == null;
    }

    private static void doRelease(@NotNull File file) {
        if (file == null) {
            EmbeddedAppLock.$$$reportNull$$$0(6);
        }
        LOCKS.remove(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerAction";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/launcher/lock/EmbeddedAppLock";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lock";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateLock";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "tryLock";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doRelease";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

