/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.lock;

import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.lock.AppLockImpl;
import com.jetbrains.launcher.lock.AppState;
import com.jetbrains.launcher.lock.ControlLock;
import com.jetbrains.launcher.lock.LauncherAwareAppLockChecker;
import com.jetbrains.launcher.lock.UpdatableAppLock;
import com.jetbrains.launcher.util.RuntimeUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LauncherAwareAppLockCheckerImpl
implements LauncherAwareAppLockChecker {
    @NotNull
    protected final UpdatableAppLock<File> myBaseLock;
    @NotNull
    protected final ControlLock myControlLock;
    @NotNull
    protected File myLauncherLogsFolder;

    LauncherAwareAppLockCheckerImpl(@NotNull File launcherLogsFolder) {
        if (launcherLogsFolder == null) {
            LauncherAwareAppLockCheckerImpl.$$$reportNull$$$0(0);
        }
        this.myBaseLock = new AppLockImpl(LauncherAwareAppLockCheckerImpl.getBaseLockFile(launcherLogsFolder));
        this.myControlLock = new ControlLock(LauncherAwareAppLockCheckerImpl.getControlLockFile(launcherLogsFolder));
        this.myLauncherLogsFolder = launcherLogsFolder;
    }

    @NotNull
    protected static File getBaseLockFile(@NotNull File launcherLogsFolder) {
        if (launcherLogsFolder == null) {
            LauncherAwareAppLockCheckerImpl.$$$reportNull$$$0(1);
        }
        File file = RuntimeUtil.getLauncherLockFile((File)launcherLogsFolder);
        if (file == null) {
            LauncherAwareAppLockCheckerImpl.$$$reportNull$$$0(2);
        }
        return file;
    }

    @NotNull
    protected static File getControlLockFile(@NotNull File launcherLogsFolder) {
        if (launcherLogsFolder == null) {
            LauncherAwareAppLockCheckerImpl.$$$reportNull$$$0(3);
        }
        File file = RuntimeUtil.getLauncherControlLockFile((File)launcherLogsFolder);
        if (file == null) {
            LauncherAwareAppLockCheckerImpl.$$$reportNull$$$0(4);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLocked() throws InitException {
        this.myControlLock.lock();
        try {
            boolean bl = this.myBaseLock.isLocked();
            return bl;
        }
        finally {
            this.myControlLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public AppState getState() throws InitException {
        this.myControlLock.lock();
        try {
            AppState appState = this.myBaseLock.getState();
            return appState;
        }
        finally {
            this.myControlLock.unlock();
        }
    }

    @Override
    @Nullable
    public File getLauncherHome() throws InitException {
        this.myControlLock.lock();
        try {
            File file = this.myBaseLock.isLocked() ? RuntimeUtil.loadLauncherHome((File)this.myLauncherLogsFolder) : null;
            return file;
        }
        catch (IOException e) {
            throw new InitException("Failed to load launcher home: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.myControlLock.unlock();
        }
    }

    @Override
    @Nullable
    public Integer getLauncherPid() throws InitException {
        this.myControlLock.lock();
        try {
            Integer n = this.myBaseLock.isLocked() ? Integer.valueOf(RuntimeUtil.loadLauncherPid((File)this.myLauncherLogsFolder)) : null;
            return n;
        }
        catch (IOException e) {
            throw new InitException("Failed to load launcher PID: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.myControlLock.unlock();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherLogsFolder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/lock/LauncherAwareAppLockCheckerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/lock/LauncherAwareAppLockCheckerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLockFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlLockFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBaseLockFile";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getControlLockFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

