/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.run;

import com.jetbrains.launcher.AppFiles;
import com.jetbrains.launcher.AppFilesEx;
import com.jetbrains.launcher.StatusDescriptor;
import com.jetbrains.launcher.run.AgentStartFacade;
import com.jetbrains.launcher.util.ExceptionUtil;
import com.jetbrains.launcher.util.ProcessUtil;
import com.jetbrains.launcher.util.RuntimeUtil;
import com.jetbrains.launcher.util.WaitFor;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

abstract class BaseAgent
implements AgentStartFacade {
    protected static final int DEFAULT_TIMEOUT_SECONDS = 30;
    @NotNull
    private final Logger LOG;
    @NotNull
    protected final AppFilesEx myAppFiles;

    protected BaseAgent(@NotNull AppFilesEx appFiles) {
        if (appFiles == null) {
            BaseAgent.$$$reportNull$$$0(0);
        }
        this.LOG = Logger.getLogger(BaseAgent.class);
        this.myAppFiles = appFiles;
    }

    @NotNull
    public final StatusDescriptor getStatus() {
        StatusDescriptor statusDescriptor = this.getStatus(false);
        if (statusDescriptor == null) {
            BaseAgent.$$$reportNull$$$0(1);
        }
        return statusDescriptor;
    }

    public final boolean stop() {
        return this.stop(false);
    }

    public final boolean stop(boolean soft) {
        this.setExitFlag();
        return this.doStop(soft);
    }

    protected abstract boolean doStop(boolean var1);

    public boolean waitForExit(int timeoutSeconds) {
        try {
            final File exitFlagFile = RuntimeUtil.getAppExitFlagFile((AppFiles)this.myAppFiles);
            new WaitFor<RuntimeException>(Long.valueOf((long)timeoutSeconds * 1000L)){

                protected boolean condition() throws RuntimeException {
                    return !exitFlagFile.exists();
                }
            };
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public final boolean kill() {
        this.setExitFlag();
        return this.doKill();
    }

    protected final boolean doKill() {
        int pid;
        try {
            pid = RuntimeUtil.loadAppPid((AppFiles)this.myAppFiles);
        }
        catch (IOException e) {
            this.LOG.debug((Object)("Failed to load process ID from file. Probably process already exited or did not report its ID. Nothing to kill. " + e));
            return true;
        }
        try {
            int killCommandExitCode = ProcessUtil.kill((int)pid);
            this.LOG.debug((Object)("Kill command exited with code " + killCommandExitCode));
            return true;
        }
        catch (IOException e) {
            ExceptionUtil.logError((Logger)this.LOG, (String)"Failed to kill process", (Throwable)e);
            return false;
        }
    }

    public final boolean stopOrKill() {
        return this.stop() || this.kill();
    }

    private void setExitFlag() {
        try {
            RuntimeUtil.setExitFlag((AppFiles)this.myAppFiles);
        }
        catch (IOException e) {
            ExceptionUtil.logWarning((Logger)this.LOG, (String)"Failed to set exit flag", (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/run/BaseAgent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/run/BaseAgent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

