/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.transport;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimeoutAwareSocketInputStream
extends InputStream {
    @NotNull
    private final Socket mySocket;
    @NotNull
    private final InputStream myInputStream;
    @Nullable
    private final Long myDeadline;

    public TimeoutAwareSocketInputStream(@NotNull Socket socket, @Nullable Integer timeoutSeconds) throws IOException {
        if (socket == null) {
            TimeoutAwareSocketInputStream.$$$reportNull$$$0(0);
        }
        this.mySocket = socket;
        this.myInputStream = socket.getInputStream();
        this.myDeadline = TimeoutAwareSocketInputStream.getDeadline(timeoutSeconds);
        if (this.myDeadline == null) {
            this.mySocket.setSoTimeout(0);
        }
    }

    @Nullable
    private static Long getDeadline(@Nullable Integer timeoutSeconds) throws IOException {
        if (timeoutSeconds == null) {
            return null;
        }
        long timeoutMillis = (long)timeoutSeconds.intValue() * 1000L;
        if (timeoutMillis > Integer.MAX_VALUE) {
            throw new IOException("Too long timeout: " + timeoutMillis);
        }
        return new Date().getTime() + timeoutMillis;
    }

    @Override
    public int read() throws IOException {
        this.updateTimeout();
        return this.myInputStream.read();
    }

    @Override
    public int read(@NotNull byte[] b) throws IOException {
        if (b == null) {
            TimeoutAwareSocketInputStream.$$$reportNull$$$0(1);
        }
        this.updateTimeout();
        return this.myInputStream.read(b);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        if (b == null) {
            TimeoutAwareSocketInputStream.$$$reportNull$$$0(2);
        }
        this.updateTimeout();
        return this.myInputStream.read(b, off, len);
    }

    private void updateTimeout() throws IOException {
        if (this.myDeadline != null) {
            long timeout = this.myDeadline - new Date().getTime();
            if (timeout <= 0L) {
                throw new SocketTimeoutException();
            }
            this.mySocket.setSoTimeout((int)timeout);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        return this.myInputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.myInputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.myInputStream.close();
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.myInputStream.mark(readLimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.myInputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.myInputStream.markSupported();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "socket";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/launcher/transport/TimeoutAwareSocketInputStream";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

