/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util.java;

import com.jetbrains.launcher.Static;
import com.jetbrains.launcher.util.CmdUtil;
import com.jetbrains.launcher.util.JavaUtil;
import com.jetbrains.launcher.util.Pair;
import com.jetbrains.launcher.util.StringUtil;
import com.jetbrains.launcher.util.java.InvalidJvmOptionException;
import com.jetbrains.launcher.util.java.JvmOptionVariableValueProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JvmOptionsMerger {
    @Static
    @NotNull
    private static final List<String> ourMultiValueOptionKeyPrefixes = Arrays.asList("ea:", "enableassertions:", "da:", "disableassertions:", "agentlib:", "agentpath:", "javaagent:");
    @Static
    @NotNull
    private static final List<String> ourMemoryOptionKeys = Arrays.asList("Xms", "Xmx", "Xss");
    @NotNull
    private static final String EMPTY_SEPARATOR = "";
    @NotNull
    private static final String OPTION_SEPARATOR = ":";
    @NotNull
    private static final String MULTI_VALUE_OPTION_SEPARATOR = "=";
    @NotNull
    private static final String XX_OPTION_PREFIX = "XX:";
    @NotNull
    private static final String XX_OPTION_SEPARATOR = "=";
    @NotNull
    private static final String ALIAS_SEPARATOR = "=";
    @NotNull
    private static final String SYSTEM_PROPERTY_SEPARATOR = "=";
    private static final char COMMENT_PREFIX = '#';
    private static final char ALIAS_PREFIX = '@';
    private static final char OPTION_PREFIX = '-';
    private static final char OPTION_TO_REMOVE_PREFIX = '+';
    private static final char ENV_SYSTEM_PROPERTY_PREFIX = '*';
    @NotNull
    private final LinkedHashMap<String, Option> myOptions = new LinkedHashMap();
    @Nullable
    private final Map<String, JvmOptionVariableValueProvider> myVariables;

    public JvmOptionsMerger(@Nullable Map<String, JvmOptionVariableValueProvider> variables) {
        this.myVariables = variables == null ? null : new HashMap<String, JvmOptionVariableValueProvider>(variables);
    }

    @NotNull
    public List<String> getRawJvmOptions() {
        List<String> list = Collections.unmodifiableList(new ArrayList<String>(){
            {
                for (Map.Entry entry : JvmOptionsMerger.this.myOptions.entrySet()) {
                    this.add(((Option)entry.getValue()).asRawString());
                }
            }
        });
        if (list == null) {
            JvmOptionsMerger.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public List<String> getJvmOptions() {
        List<String> list = Collections.unmodifiableList(new ArrayList<String>(){
            {
                for (Map.Entry entry : JvmOptionsMerger.this.myOptions.entrySet()) {
                    Option option = (Option)entry.getValue();
                    if (!option.isRealOption() || option.isEnvSystemProperty()) continue;
                    this.add(option.asString());
                }
            }
        });
        if (list == null) {
            JvmOptionsMerger.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public Map<String, String> getEnvSystemProperties() {
        Map<String, String> map = Collections.unmodifiableMap(new LinkedHashMap<String, String>(){
            {
                for (Map.Entry entry : JvmOptionsMerger.this.myOptions.entrySet()) {
                    Option option = (Option)entry.getValue();
                    if (!option.isRealOption() || !option.isEnvSystemProperty()) continue;
                    this.put(((String)entry.getKey()).substring(1), StringUtil.notNullize((String)option.getValue()));
                }
            }
        });
        if (map == null) {
            JvmOptionsMerger.$$$reportNull$$$0(2);
        }
        return map;
    }

    public void addJvmOptions(@NotNull List<String> jvmOptions) throws InvalidJvmOptionException {
        if (jvmOptions == null) {
            JvmOptionsMerger.$$$reportNull$$$0(3);
        }
        for (String jvmOption : jvmOptions) {
            this.addJvmOption(jvmOption);
        }
    }

    public void addJvmOption(@NotNull String jvmOption) throws InvalidJvmOptionException {
        Option newOption;
        if (jvmOption == null) {
            JvmOptionsMerger.$$$reportNull$$$0(4);
        }
        if ((newOption = this.parseOption(jvmOption)) == null) {
            return;
        }
        if (newOption.isPermSizeOption() && JavaUtil.isCurrentJavaAtLeast18()) {
            return;
        }
        if (newOption.isMetaspaceSizeOption() && !JavaUtil.isCurrentJavaAtLeast18()) {
            return;
        }
        String key = newOption.getKey();
        Option oldOption = this.myOptions.get(key);
        if (newOption.isOptionToRemove()) {
            if (oldOption == null || newOption.removes(oldOption)) {
                this.myOptions.remove(key);
                this.myOptions.put(key, newOption);
            }
        } else {
            if (newOption.isExpandedAlias()) {
                this.myOptions.remove(key);
            }
            this.myOptions.put(key, oldOption == null || oldOption.isOptionToRemove() ? newOption : JvmOptionsMerger.mergeOptions(key, oldOption, newOption));
        }
    }

    @Nullable
    Option parseOption(@NotNull String jvmOption) throws InvalidJvmOptionException {
        if (jvmOption == null) {
            JvmOptionsMerger.$$$reportNull$$$0(5);
        }
        return this.parseOption(jvmOption, new ParsingContext());
    }

    @Nullable
    private Option parseOption(@NotNull String jvmOption, @NotNull ParsingContext context) throws InvalidJvmOptionException {
        if (jvmOption == null) {
            JvmOptionsMerger.$$$reportNull$$$0(6);
        }
        if (context == null) {
            JvmOptionsMerger.$$$reportNull$$$0(7);
        }
        return this.doParseOption(CmdUtil.unwrap((String)jvmOption.trim()), context);
    }

    @Nullable
    private Option doParseOption(@NotNull String jvmOption, @NotNull ParsingContext context) throws InvalidJvmOptionException {
        boolean isAlias;
        if (jvmOption == null) {
            JvmOptionsMerger.$$$reportNull$$$0(8);
        }
        if (context == null) {
            JvmOptionsMerger.$$$reportNull$$$0(9);
        }
        if (jvmOption.length() == 0) {
            return null;
        }
        char prefix = jvmOption.charAt(0);
        if (prefix == '#') {
            return null;
        }
        String pureJvmOption = jvmOption.substring(1);
        Pair<Boolean, Option> result = this.resolveAlias(prefix, pureJvmOption, jvmOption, context);
        if (((Boolean)result.getFirst()).booleanValue()) {
            return (Option)result.getSecond();
        }
        String alias = context.getMainAlias();
        CmdUtil.SystemProperty property = CmdUtil.parseSystemProperty((String)jvmOption);
        if (property != null) {
            return new Option(prefix, "D" + property.getName(), "=", property.getValue(), alias, this.myVariables);
        }
        if (prefix != '-' && prefix != '+' && prefix != '@') {
            throw new InvalidJvmOptionException("Failed to parse JVM option: " + jvmOption);
        }
        for (String key : ourMemoryOptionKeys) {
            if (!pureJvmOption.startsWith(key)) continue;
            String value = pureJvmOption.substring(key.length());
            return new Option(prefix, key, EMPTY_SEPARATOR, value.length() == 0 ? null : value, alias, this.myVariables);
        }
        boolean isXXOption = pureJvmOption.startsWith(XX_OPTION_PREFIX);
        boolean bl = isAlias = prefix == '@';
        String separator = isXXOption ? "=" : (isAlias ? "=" : (JvmOptionsMerger.isMultiValueOption(pureJvmOption) ? "=" : OPTION_SEPARATOR));
        KeyValue keyValue = KeyValue.parse(pureJvmOption, separator);
        String key = keyValue.getKey();
        String value = keyValue.getValue();
        if (isXXOption) {
            key = key.substring(XX_OPTION_PREFIX.length());
            Boolean flag = null;
            if (value == null) {
                if (key.startsWith("+")) {
                    flag = true;
                }
                if (key.startsWith("-")) {
                    flag = false;
                }
                if (flag != null) {
                    key = key.substring(1);
                }
            }
            return new XXOption(prefix, key, separator, flag, value, alias, this.myVariables);
        }
        return isAlias ? new Alias(prefix, key, separator, value, alias) : new Option(prefix, key, separator, value, alias, this.myVariables);
    }

    @NotNull
    private Pair<Boolean, Option> resolveAlias(char prefix, @NotNull String pureJvmOption, @NotNull String jvmOption, @NotNull ParsingContext context) throws InvalidJvmOptionException {
        block8: {
            Pair pair;
            if (pureJvmOption == null) {
                JvmOptionsMerger.$$$reportNull$$$0(10);
            }
            if (jvmOption == null) {
                JvmOptionsMerger.$$$reportNull$$$0(11);
            }
            if (context == null) {
                JvmOptionsMerger.$$$reportNull$$$0(12);
            }
            try {
                String aliasValue;
                if (prefix != '-' && prefix != '+') break block8;
                KeyValue keyValue = KeyValue.parse(pureJvmOption, OPTION_SEPARATOR);
                Option alias = this.myOptions.get('@' + keyValue.getKey());
                if (alias == null || !alias.isAlias() || (aliasValue = JvmOptionsMerger.resolveAliasValue(alias.getValue(), keyValue.getValue())) == null) break block8;
                context.visitAlias(pureJvmOption, jvmOption);
                pair = Pair.create((Object)true, (Object)this.parseOption(aliasValue, context));
            }
            catch (InvalidJvmOptionException e) {
                throw new InvalidJvmOptionException("Failed to parse JVM option: " + jvmOption + " (" + e.getMessage() + ")", e);
            }
            if (pair == null) {
                JvmOptionsMerger.$$$reportNull$$$0(13);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)false, null);
        if (pair == null) {
            JvmOptionsMerger.$$$reportNull$$$0(14);
        }
        return pair;
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    private static String resolveAliasValue(@Nullable String aliasValue, @Nullable String userValue) {
        int curPos;
        if (aliasValue == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int length = aliasValue.length();
        int prevPos = 0;
        while ((curPos = aliasValue.indexOf(36, prevPos)) != -1) {
            String defaultValue;
            result.append(aliasValue, prevPos, curPos);
            prevPos = curPos;
            if (prevPos == length - 1) break;
            char boundSymbol = aliasValue.charAt(++prevPos);
            ++prevPos;
            if (boundSymbol == '$') {
                result.append('$');
                continue;
            }
            curPos = aliasValue.indexOf(boundSymbol, prevPos);
            if (curPos == -1) {
                defaultValue = aliasValue.substring(prevPos);
                prevPos = length;
            } else {
                defaultValue = aliasValue.substring(prevPos, curPos);
                prevPos = curPos + 1;
            }
            result.append(StringUtil.notNullize((String)userValue, (String)defaultValue));
        }
        result.append(aliasValue, prevPos, length);
        return result.toString();
    }

    private static boolean isMultiValueOption(@NotNull String pureJvmOption) {
        if (pureJvmOption == null) {
            JvmOptionsMerger.$$$reportNull$$$0(15);
        }
        for (String keyPrefix : ourMultiValueOptionKeyPrefixes) {
            if (!pureJvmOption.startsWith(keyPrefix)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Option mergeOptions(@NotNull String key, @NotNull Option oldOption, @NotNull Option newOption) {
        if (key == null) {
            JvmOptionsMerger.$$$reportNull$$$0(16);
        }
        if (oldOption == null) {
            JvmOptionsMerger.$$$reportNull$$$0(17);
        }
        if (newOption == null) {
            JvmOptionsMerger.$$$reportNull$$$0(18);
        }
        Option option = ourMemoryOptionKeys.contains(key) || oldOption.isSizeOption() && newOption.isSizeOption() ? JvmOptionsMerger.maxValueOption(oldOption, newOption) : newOption;
        if (option == null) {
            JvmOptionsMerger.$$$reportNull$$$0(19);
        }
        return option;
    }

    @NotNull
    private static Option maxValueOption(@NotNull Option option1, @NotNull Option option2) {
        if (option1 == null) {
            JvmOptionsMerger.$$$reportNull$$$0(20);
        }
        if (option2 == null) {
            JvmOptionsMerger.$$$reportNull$$$0(21);
        }
        Option option = JvmOptionsMerger.getLongValue(option1) > JvmOptionsMerger.getLongValue(option2) ? option1 : option2;
        if (option == null) {
            JvmOptionsMerger.$$$reportNull$$$0(22);
        }
        return option;
    }

    private static long getLongValue(@NotNull Option option) {
        String value;
        if (option == null) {
            JvmOptionsMerger.$$$reportNull$$$0(23);
        }
        if (StringUtil.isEmpty((String)(value = option.getValue()))) {
            return 0L;
        }
        char mod = Character.toLowerCase(value.charAt(value.length() - 1));
        long multiplier = mod == 'k' ? 1024L : (mod == 'm' ? 0x100000L : (mod == 'g' ? 0x40000000L : 1L));
        try {
            return Long.parseLong(multiplier == 1L ? value : value.substring(0, value.length() - 1)) * multiplier;
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    private static String replaceVariables(@Nullable String value, @Nullable Map<String, JvmOptionVariableValueProvider> variables) throws InvalidJvmOptionException {
        if (value == null || variables == null) {
            return value;
        }
        StringBuilder result = new StringBuilder();
        int prevPos = 0;
        int pos = 0;
        while (pos != -1) {
            pos = value.indexOf(37, prevPos);
            if (pos == -1) {
                result.append(value, prevPos, value.length());
                continue;
            }
            result.append(value, prevPos, pos);
            prevPos = pos;
            pos = value.indexOf(37, prevPos + 1);
            if (pos == -1) {
                result.append(value, prevPos, value.length());
                continue;
            }
            String variableName = value.substring(prevPos + 1, pos);
            if (variableName.isEmpty()) {
                result.append('%');
            } else {
                JvmOptionVariableValueProvider variableValueProvider = variables.get(variableName);
                if (variableValueProvider != null) {
                    result.append(variableValueProvider.get());
                } else {
                    result.append(value, prevPos, pos + 1);
                }
            }
            prevPos = pos + 1;
        }
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/util/java/JvmOptionsMerger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmOptions";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmOption";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pureJvmOption";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldOption";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newOption";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option1";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option2";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawJvmOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getJvmOptions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvSystemProperties";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/util/java/JvmOptionsMerger";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAlias";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeOptions";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "maxValueOption";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addJvmOptions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addJvmOption";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseOption";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doParseOption";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveAlias";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isMultiValueOption";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptions";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "maxValueOption";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLongValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class KeyValue {
        @NotNull
        private final String myKey;
        @Nullable
        private final String myValue;

        private KeyValue(@NotNull String key, @Nullable String value) {
            if (key == null) {
                KeyValue.$$$reportNull$$$0(0);
            }
            this.myKey = key;
            this.myValue = value;
        }

        @NotNull
        private String getKey() {
            String string = this.myKey;
            if (string == null) {
                KeyValue.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        private String getValue() {
            return this.myValue;
        }

        @NotNull
        private static KeyValue parse(@NotNull String str, @NotNull String separator) {
            int sepPos;
            if (str == null) {
                KeyValue.$$$reportNull$$$0(2);
            }
            if (separator == null) {
                KeyValue.$$$reportNull$$$0(3);
            }
            KeyValue keyValue = (sepPos = str.indexOf(separator)) == -1 ? new KeyValue(str, null) : new KeyValue(str.substring(0, sepPos), str.substring(sepPos + 1));
            if (keyValue == null) {
                KeyValue.$$$reportNull$$$0(4);
            }
            return keyValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/launcher/util/java/JvmOptionsMerger$KeyValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "separator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/launcher/util/java/JvmOptionsMerger$KeyValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ParsingContext {
        @NotNull
        private final Set<String> myVisitedAliases = new HashSet<String>();
        @Nullable
        private String myMainAlias;

        private ParsingContext() {
        }

        public void visitAlias(@NotNull String pureJvmOption, @NotNull String jvmOption) throws InvalidJvmOptionException {
            if (pureJvmOption == null) {
                ParsingContext.$$$reportNull$$$0(0);
            }
            if (jvmOption == null) {
                ParsingContext.$$$reportNull$$$0(1);
            }
            if (!this.myVisitedAliases.add(pureJvmOption)) {
                throw new InvalidJvmOptionException("There is an alias cycle");
            }
            if (this.myMainAlias == null) {
                this.myMainAlias = jvmOption;
            }
        }

        @Nullable
        public String getMainAlias() {
            return this.myMainAlias;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pureJvmOption";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "jvmOption";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/launcher/util/java/JvmOptionsMerger$ParsingContext";
            objectArray[2] = "visitAlias";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Alias
    extends Option {
        private Alias(char prefix, @NotNull String key, @NotNull String separator, @Nullable String value, @Nullable String alias) {
            if (key == null) {
                Alias.$$$reportNull$$$0(0);
            }
            if (separator == null) {
                Alias.$$$reportNull$$$0(1);
            }
            super(prefix, '@' + key, key, key, separator, value, value, alias, Alias.isForcedRemove(alias));
        }

        @Override
        protected boolean canChangePrefix() {
            return false;
        }

        @Override
        public boolean isOptionToRemove() {
            return this.getValue() == null;
        }

        @Override
        public boolean isAlias() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "key";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "separator";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/launcher/util/java/JvmOptionsMerger$Alias";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class XXOption
    extends Option {
        @NotNull
        private final String myOriginalKey;
        @Nullable
        private final Boolean myFlag;

        private XXOption(char prefix, @NotNull String key, @NotNull String separator, @Nullable Boolean flag, @Nullable String value, @Nullable String alias, @Nullable Map<String, JvmOptionVariableValueProvider> variables) throws InvalidJvmOptionException {
            if (key == null) {
                XXOption.$$$reportNull$$$0(0);
            }
            if (separator == null) {
                XXOption.$$$reportNull$$$0(1);
            }
            super(prefix, JvmOptionsMerger.XX_OPTION_PREFIX + key, JvmOptionsMerger.XX_OPTION_PREFIX + (flag == null ? JvmOptionsMerger.EMPTY_SEPARATOR : (flag != false ? "+" : "-")) + key, separator, value, alias, XXOption.isForcedRemove(alias), variables);
            this.myOriginalKey = key;
            this.myFlag = flag;
        }

        @Override
        public boolean removes(@NotNull Option that) {
            if (that == null) {
                XXOption.$$$reportNull$$$0(2);
            }
            if (this.myFlag == null) {
                return super.removes(that);
            }
            return that.isOptionToRemove() || that instanceof XXOption && this.myFlag.equals(((XXOption)that).myFlag);
        }

        @Override
        public boolean isSizeOption() {
            return this.myFlag == null && this.myOriginalKey.endsWith("Size");
        }

        @Override
        public boolean isPermSizeOption() {
            return this.myOriginalKey.equals("PermSize") || this.myOriginalKey.equals("MaxPermSize");
        }

        @Override
        public boolean isMetaspaceSizeOption() {
            return this.myOriginalKey.equals("MetaspaceSize") || this.myOriginalKey.equals("MaxMetaspaceSize");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "separator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "that";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/launcher/util/java/JvmOptionsMerger$XXOption";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class Option {
        private final char myPrefix;
        @NotNull
        private final String myKey;
        @NotNull
        private final String myRawDisplayKey;
        @NotNull
        private final String myDisplayKey;
        @NotNull
        private final String mySeparator;
        @Nullable
        private final String myRawValue;
        @Nullable
        private final String myValue;
        @Nullable
        private final String myAlias;

        private Option(char prefix, @NotNull String key, @NotNull String separator, @Nullable String value, @Nullable String alias, @Nullable Map<String, JvmOptionVariableValueProvider> variables) throws InvalidJvmOptionException {
            if (key == null) {
                Option.$$$reportNull$$$0(0);
            }
            if (separator == null) {
                Option.$$$reportNull$$$0(1);
            }
            this(prefix, key, key, separator, value, alias, Option.isForcedRemove(alias), variables);
        }

        private Option(char prefix, @NotNull String key, @NotNull String displayKey, @NotNull String separator, @Nullable String value, @Nullable String alias, boolean isForcedRemove, @Nullable Map<String, JvmOptionVariableValueProvider> variables) throws InvalidJvmOptionException {
            if (key == null) {
                Option.$$$reportNull$$$0(2);
            }
            if (displayKey == null) {
                Option.$$$reportNull$$$0(3);
            }
            if (separator == null) {
                Option.$$$reportNull$$$0(4);
            }
            this(prefix, key, displayKey, JvmOptionsMerger.replaceVariables(displayKey, variables), separator, value, isForcedRemove ? null : JvmOptionsMerger.replaceVariables(value, variables), alias, isForcedRemove);
        }

        private Option(char prefix, @NotNull String key, @NotNull String rawDisplayKey, @NotNull String displayKey, @NotNull String separator, @Nullable String rawValue, @Nullable String value, @Nullable String alias, boolean isForcedRemove) {
            if (key == null) {
                Option.$$$reportNull$$$0(5);
            }
            if (rawDisplayKey == null) {
                Option.$$$reportNull$$$0(6);
            }
            if (displayKey == null) {
                Option.$$$reportNull$$$0(7);
            }
            if (separator == null) {
                Option.$$$reportNull$$$0(8);
            }
            this.myPrefix = this.canChangePrefix() && isForcedRemove ? 43 : prefix;
            this.myKey = key;
            this.myRawDisplayKey = rawDisplayKey;
            this.myDisplayKey = displayKey;
            this.mySeparator = separator;
            this.myRawValue = isForcedRemove ? null : rawValue;
            this.myValue = isForcedRemove ? null : value;
            this.myAlias = alias;
        }

        protected boolean canChangePrefix() {
            return true;
        }

        protected static boolean isForcedRemove(@Nullable String alias) {
            return !StringUtil.isEmpty((String)alias) && alias.charAt(0) == '+';
        }

        @NotNull
        public String getKey() {
            String string = this.myKey;
            if (string == null) {
                Option.$$$reportNull$$$0(9);
            }
            return string;
        }

        @Nullable
        public String getValue() {
            return this.myValue;
        }

        @NotNull
        public String asRawString() {
            String string = CmdUtil.wrap((String)StringUtil.notNullize((String)this.myAlias, (String)this.makeString(this.myRawDisplayKey, this.myRawValue)));
            if (string == null) {
                Option.$$$reportNull$$$0(10);
            }
            return string;
        }

        @NotNull
        public String asString() {
            String string = this.makeString(this.myDisplayKey, this.myValue);
            if (string == null) {
                Option.$$$reportNull$$$0(11);
            }
            return string;
        }

        @NotNull
        private String makeString(@NotNull String key, @Nullable String value) {
            if (key == null) {
                Option.$$$reportNull$$$0(12);
            }
            String string = this.myPrefix + key + (value == null ? JvmOptionsMerger.EMPTY_SEPARATOR : this.mySeparator + value);
            if (string == null) {
                Option.$$$reportNull$$$0(13);
            }
            return string;
        }

        public boolean isEnvSystemProperty() {
            return this.myPrefix == '*';
        }

        public boolean isRealOption() {
            return !this.isAlias() && !this.isOptionToRemove();
        }

        public boolean isOptionToRemove() {
            return this.myPrefix == '+';
        }

        public boolean isAlias() {
            return false;
        }

        public boolean removes(@NotNull Option that) {
            if (that == null) {
                Option.$$$reportNull$$$0(14);
            }
            return that.isOptionToRemove() || this.myValue == null || this.myValue.equals(that.myValue);
        }

        public boolean isSizeOption() {
            return false;
        }

        public boolean isPermSizeOption() {
            return false;
        }

        public boolean isMetaspaceSizeOption() {
            return false;
        }

        public boolean isExpandedAlias() {
            return this.myAlias != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "separator";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayKey";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rawDisplayKey";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/launcher/util/java/JvmOptionsMerger$Option";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "that";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/launcher/util/java/JvmOptionsMerger$Option";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asRawString";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asString";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "makeString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "makeString";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "removes";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

