/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.BaseWinServiceSubCommand;
import com.jetbrains.launcher.log.ConsoleLogger;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WinServiceInstall
extends BaseWinServiceSubCommand {
    @NotNull
    private static final String NAME = "install";

    @NotNull
    public String getName() {
        if (NAME == null) {
            WinServiceInstall.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    protected boolean requiresInstalledService() {
        return false;
    }

    @NotNull
    protected List<String> buildProcessCmdLine(@NotNull LauncherContext context) {
        if (context == null) {
            WinServiceInstall.$$$reportNull$$$0(1);
        }
        List<String> list = WinServiceInstall.getJetServiceCmdLine(context, NAME);
        if (list == null) {
            WinServiceInstall.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    protected LauncherExitCode doRun(@NotNull LauncherContextEx context) throws InitException {
        if (context == null) {
            WinServiceInstall.$$$reportNull$$$0(3);
        }
        if (context.getArguments().getApplicationArguments().isEmpty()) {
            throw new IllegalArgumentException();
        }
        LauncherExitCode launcherExitCode = super.doRun(context);
        if (launcherExitCode == null) {
            WinServiceInstall.$$$reportNull$$$0(4);
        }
        return launcherExitCode;
    }

    @Nullable
    protected LauncherExitCode afterServiceConfigured(@NotNull LauncherContextEx context) throws InitException {
        if (context == null) {
            WinServiceInstall.$$$reportNull$$$0(5);
        }
        return this.afterServiceConfiguredForInstall(context);
    }

    protected int getIllegalStateExitCodeValue() {
        return 1;
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            WinServiceInstall.$$$reportNull$$$0(6);
        }
        if (context == null) {
            WinServiceInstall.$$$reportNull$$$0(7);
        }
        printer.print(this.getFullName(), "installs " + context.getAppConfig().getAppName().getName() + " Windows service, " + this.getComplexCommandUsageText());
    }

    public void printStandaloneUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            WinServiceInstall.$$$reportNull$$$0(8);
        }
        if (context == null) {
            WinServiceInstall.$$$reportNull$$$0(9);
        }
        String name = context.getAppConfig().getAppName().getName();
        printer.print(this.getFullName() + " /runAsSystem", "installs " + name + " Windows service to be run under system account");
        printer.print(this.getFullName() + " /user=<user> [/domain=<domain>] /password=<password>", "installs " + name + " Windows service to be run under the specified user account");
        ConsoleLogger.error((String)"Use \"--force\" option to uninstall the service first in case it already exists");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/WinServiceInstall";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/WinServiceInstall";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildProcessCmdLine";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildProcessCmdLine";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "afterServiceConfigured";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "printStandaloneUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

