/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.jetty;

import com.jetbrains.launcher.exceptions.StartupException;
import com.jetbrains.service.jetty.JettyServiceBase;
import com.jetbrains.service.util.ServiceProperties;
import com.jetbrains.service.util.UrlUtil;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.Slf4jRequestLog;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleJettyService
extends JettyServiceBase {
    public static final int JETTY_STOP_TIMEOUT_MS = 5000;

    @Override
    @NotNull
    protected Server createServer(Properties allProperties) throws Exception {
        Server server = this.createEmptyServer(allProperties);
        HandlerCollection contextHandler = this.getHandlerCollection(allProperties, server);
        HandlerCollection rootHandler = new HandlerCollection();
        rootHandler.addHandler((Handler)contextHandler);
        if (!Boolean.valueOf(allProperties.getProperty("disable-access-log")).booleanValue()) {
            String servletContainerServiceId = allProperties.getProperty("id");
            rootHandler.addHandler((Handler)this.createRequestLogHandler(servletContainerServiceId));
        }
        server.setHandler((Handler)rootHandler);
        return server;
    }

    @NotNull
    protected Server createEmptyServer(@NotNull Properties allProperties) {
        int listenPort = Integer.parseInt(PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)allProperties, "port"));
        String listenAddress = PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)allProperties, "listen");
        return SimpleJettyService.createJettyServer(listenPort, listenAddress);
    }

    public static Server createJettyServer(int listenPort, @NotNull String listenAddress) {
        return SimpleJettyService.createJettyServer(listenPort, listenAddress, 5000, SimpleJettyService.getIdleTimeout());
    }

    private static Server createJettyServer(int listenPort, @NotNull String listenAddress, int stopTimeout, int idleTimeout) {
        Integer threadPoolSize = Integer.getInteger("jetbrains.server.thread.pool.size");
        QueuedThreadPool threadPool = threadPoolSize != null ? new QueuedThreadPool(threadPoolSize.intValue()) : null;
        Server server = new Server((ThreadPool)threadPool);
        server.setStopTimeout((long)stopTimeout);
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        httpConfiguration.setRequestHeaderSize(SimpleJettyService.getRequestHeaderBufferSize().intValue());
        httpConfiguration.setResponseHeaderSize(SimpleJettyService.getResponseHeaderBufferSize().intValue());
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfiguration);
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{httpConnectionFactory});
        connector.setHost(listenAddress);
        connector.setPort(listenPort);
        connector.setIdleTimeout((long)idleTimeout);
        server.setConnectors(new Connector[]{connector});
        return server;
    }

    @NotNull
    protected static Integer getRequestHeaderBufferSize() {
        return Integer.getInteger("jetbrains.http.request.header.buffer.size", 8192);
    }

    @NotNull
    protected static Integer getIdleTimeout() {
        return Integer.getInteger("jetbrains.http.connection.idle.timeout", 1800000);
    }

    @NotNull
    protected static Integer getResponseHeaderBufferSize() {
        return Integer.getInteger("jetbrains.http.response.header.buffer.size", 16384);
    }

    @NotNull
    protected HandlerCollection getHandlerCollection(@NotNull Properties allProperties, @NotNull Server server) throws Exception {
        ContextHandlerCollection handlerCollection = new ContextHandlerCollection();
        WebAppContext serviceWebContext = this.getServiceContext(allProperties, server);
        handlerCollection.addHandler((Handler)serviceWebContext);
        return handlerCollection;
    }

    @NotNull
    protected WebAppContext getServiceContext(@NotNull Properties allProperties, @NotNull Server server) throws IOException, StartupException {
        File webXmlFile;
        String serviceId = PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)allProperties, "id");
        File webApp = this.getWebApp();
        if (!webApp.isDirectory()) {
            throw new StartupException("Failed to find web application home directory: " + webApp);
        }
        WebAppContext serviceWebContext = new WebAppContext();
        if (!Boolean.valueOf(PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, serviceId, "is-internal-service")).booleanValue()) {
            serviceWebContext.addServerClass("org.slf4j.");
            serviceWebContext.addServerClass("org.apache.log4j.");
            serviceWebContext.addServerClass("org.apache.logging.log4j.");
            serviceWebContext.addServerClass("org.apache.commons.logging.");
        }
        if ((webXmlFile = new File(webApp, "WEB-INF/web.xml")).exists()) {
            serviceWebContext.setDescriptor(webXmlFile.getCanonicalPath());
            this.getLogger().debug(String.format("Web application will be started from: %s (web.xml: %s) ", webApp, webXmlFile));
        } else if (Boolean.valueOf(PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, serviceId, "is-annotation-based")).booleanValue()) {
            Configuration.ClassList classList = Configuration.ClassList.serverDefault((Server)server);
            if (!classList.contains((Object)AnnotationConfiguration.class.getName())) {
                classList.add((Object)AnnotationConfiguration.class.getName());
            }
            serviceWebContext.setConfigurationClasses((List)classList);
        } else {
            throw new StartupException(String.format("Failed find web application web.xml file: %s. Property [%s] should be set to %s if this service is annotation based", webXmlFile, "is-annotation-based", Boolean.TRUE));
        }
        Boolean isParentFirstClassLoading = Boolean.valueOf(PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, serviceId, "is-parent-first-class-loading"));
        if (isParentFirstClassLoading.booleanValue()) {
            serviceWebContext.setParentLoaderPriority(true);
        }
        serviceWebContext.setDisplayName(this.getServicePresentableName(allProperties));
        serviceWebContext.setLogUrlOnStart(true);
        serviceWebContext.setThrowUnavailableOnStartupException(true);
        serviceWebContext.setResourceBase(webApp.getCanonicalPath());
        String serviceContext = PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)allProperties, serviceId, "context");
        serviceWebContext.setContextPath(serviceContext);
        if (this.shouldSetPropertiesToInitParameters(allProperties, serviceWebContext)) {
            this.setInitParameters(allProperties, (ContextHandler)serviceWebContext);
        }
        if (Boolean.valueOf(PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, serviceId, "gzip-enable")).booleanValue()) {
            serviceWebContext.setGzipHandler(this.buildGzipHandler(allProperties, serviceId));
        }
        return serviceWebContext;
    }

    @NotNull
    protected GzipHandler buildGzipHandler(Properties allProperties, String serviceId) {
        String syncFlushString;
        String compressLevelString;
        String minGzipSizeString;
        String checkGzExistsString;
        GzipHandler gzipHandler = new GzipHandler();
        String[] includedMimeTypes = this.getParameters(allProperties, serviceId, "gzip-included-mime-types");
        String[] excludedMimeTypes = this.getParameters(allProperties, serviceId, "gzip-excluded-mime-types");
        String[] includedMethods = this.getParameters(allProperties, serviceId, "gzip-included-methods");
        String[] excludedMethods = this.getParameters(allProperties, serviceId, "gzip-excluded-methods");
        String[] includedPaths = this.getParameters(allProperties, serviceId, "gzip-included-paths");
        String[] excludedPaths = this.getParameters(allProperties, serviceId, "gzip-excluded-paths");
        String[] includedAgentPatterns = this.getParameters(allProperties, serviceId, "gzip-included-agent-patterns");
        String[] excludedAgentPatterns = this.getParameters(allProperties, serviceId, "gzip-excluded-agent-patterns");
        if (includedMimeTypes != null) {
            gzipHandler.setIncludedMimeTypes(includedMimeTypes);
        }
        if (excludedMimeTypes != null) {
            gzipHandler.setExcludedMimeTypes(excludedMimeTypes);
        }
        if (includedMethods != null) {
            gzipHandler.setIncludedMethods(includedMethods);
        }
        if (excludedMethods != null) {
            gzipHandler.setExcludedMethods(excludedMethods);
        }
        if (includedPaths != null) {
            gzipHandler.setIncludedPaths(includedPaths);
        }
        if (excludedPaths != null) {
            gzipHandler.setExcludedPaths(excludedPaths);
        }
        if (includedAgentPatterns != null) {
            gzipHandler.setIncludedAgentPatterns(includedAgentPatterns);
        }
        if (excludedAgentPatterns != null) {
            gzipHandler.setExcludedAgentPatterns(excludedAgentPatterns);
        }
        if ((checkGzExistsString = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, serviceId, "gzip-check-exists")) != null) {
            gzipHandler.setCheckGzExists(Boolean.valueOf(checkGzExistsString).booleanValue());
        }
        if ((minGzipSizeString = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, serviceId, "gzip-min-size")) != null) {
            gzipHandler.setMinGzipSize(Integer.valueOf(minGzipSizeString).intValue());
        }
        if ((compressLevelString = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, serviceId, "gzip-compression-level")) != null) {
            gzipHandler.setCompressionLevel(Integer.valueOf(compressLevelString).intValue());
        }
        if ((syncFlushString = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, serviceId, "gzip-sync-flush")) != null) {
            gzipHandler.setSyncFlush(Boolean.valueOf(syncFlushString).booleanValue());
        }
        return gzipHandler;
    }

    @Nullable
    private String[] getParameters(Properties allProperties, String serviceId, String propertyName) {
        return StringUtils.split((String)PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, serviceId, propertyName), (String)",");
    }

    protected boolean shouldSetPropertiesToInitParameters(@NotNull Properties allProperties, @NotNull WebAppContext serviceWebContext) {
        return true;
    }

    @NotNull
    protected final RequestLogHandler createRequestLogHandler(@NotNull String servletContainerServiceId) {
        Slf4jRequestLog requestLog = new Slf4jRequestLog();
        requestLog.setLoggerName(requestLog.getLoggerName() + "." + servletContainerServiceId);
        requestLog.setLogLatency(true);
        requestLog.setExtended(true);
        requestLog.setLogTimeZone("GMT");
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        return requestLogHandler;
    }

    @NotNull
    protected final ContextHandlerCollection getContextHandlerCollection() {
        Server server = this.getServer();
        if (server == null) {
            throw new IllegalStateException("Server is not initialized to the moment");
        }
        Handler serverHandler = server.getHandler();
        ContextHandlerCollection contextHandlerCollection = null;
        if (serverHandler instanceof ContextHandlerCollection) {
            contextHandlerCollection = (ContextHandlerCollection)serverHandler;
        } else if (serverHandler instanceof HandlerCollection) {
            for (Handler handler : ((HandlerCollection)serverHandler).getHandlers()) {
                if (!(handler instanceof ContextHandlerCollection)) continue;
                if (contextHandlerCollection == null) {
                    contextHandlerCollection = (ContextHandlerCollection)handler;
                    continue;
                }
                throw new IllegalStateException(String.format("Several %s were found among Server %s handlers", ContextHandlerCollection.class.getSimpleName(), server));
            }
        }
        if (contextHandlerCollection != null) {
            return contextHandlerCollection;
        }
        throw new IllegalStateException(String.format("There is no %s was found among Server %s handlers", ContextHandlerCollection.class.getSimpleName(), server));
    }

    @NotNull
    protected File getWebApp() {
        return new File(this.getServiceHome(), "web");
    }

    @Override
    @NotNull
    protected String getLogFileName(@NotNull Properties properties) {
        return this.getMandatoryProperty("id", properties) + ".log";
    }

    @Override
    @NotNull
    protected Properties getDefaultProperties() {
        Properties properties = super.getDefaultProperties();
        properties.setProperty(ServiceProperties.LOGS_DIR_PROPERTY, this.getServiceHome().toPath().resolve("logs").toString());
        properties.setProperty(ServiceProperties.TEMP_DIR_PROPERTY, this.getServiceHome().toPath().resolve("temp").toString());
        properties.setProperty("port", "8080");
        properties.setProperty("listen", "127.0.0.1");
        properties.setProperty("context", "/");
        properties.setProperty("id", "FAKE_SERVICE_ID");
        properties.setProperty("presentation-service-name", "FAKE_SERVICE_PRESENTATION_NAME");
        return properties;
    }

    @Override
    protected void onStarted(@NotNull Properties properties) {
        super.onStarted(properties);
        this.logListenAddressStringOnStartup(properties);
    }

    protected void logListenAddressStringOnStartup(@NotNull Properties properties) {
        String listenOnString = UrlUtil.trimSlashes((String)UrlUtil.combineUrls((String)(PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)properties, "listen") + ":" + PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)properties, "port")), (String)PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)properties, "context")));
        this.getLogger().info(String.format("%s is listening on {%s}", this.getServicePresentableName(properties), listenOnString));
    }
}

