/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum BundleProperty {
    BASE_URL("base-url"),
    DATA_DIR("data-dir"),
    TEMP_DIR("temp-dir"),
    LOGS_DIR("logs-dir"),
    BACKUPS_DIR("backups-dir"),
    ROOT_PASSWORD("root-password"),
    ROOT_USER("root-user"),
    LISTEN_PORT("listen-port"),
    LISTEN_ADDRESS("listen-address"),
    LOCALE("locale"),
    INSTALLATION_UUID("installation-uuid"),
    CURRENT_PRODUCT_VERSION("current-product-version", true),
    PREVIOUSLY_STARTED_PRODUCT_VERSION("previously-started-product-version"),
    PRODUCT_VERSION("product-version"),
    INSTALLATION_DIR("installation-dir", true),
    HUB_URL("hub-url"),
    ALLOW_ANONYMOUS_ACCESS("allow-anonymous-access"),
    STATISTICS_UPLOAD("statistics-upload"),
    ADDITIONAL_KEYSTORE_PATH("additional-keystore-path", true),
    ADDITIONAL_KEYSTORE_PASSWORD("additional-keystore-password"),
    ADDITIONAL_KEYSTORE_HUB_KEY_PASSWORD("additional-keystore-hub-key-password"),
    BACKEND_API_TOKEN("backend-api-token", true),
    ENTROPY_CHECK_FLAG("entropy-check");

    public static final String BUNDLE_PREFIX = "bundle.";
    private final String myName;
    private final boolean myIsComputable;
    private static final Map<String, BundleProperty> shortNameToProperty;

    private BundleProperty(String name) {
        this(name, false);
    }

    private BundleProperty(String name, boolean isComputable) {
        this.myName = name;
        this.myIsComputable = isComputable;
    }

    public String getName() {
        return this.myName;
    }

    public String getPrefixedName() {
        return BUNDLE_PREFIX + this.myName;
    }

    public static boolean isBundleProperty(String propertyName) {
        String shortName = propertyName.startsWith(BUNDLE_PREFIX) ? propertyName.substring(BUNDLE_PREFIX.length(), propertyName.length()) : propertyName;
        return shortNameToProperty.containsKey(shortName) || PropertyPart.isKnownProperty(shortName);
    }

    public static BundleProperty getSimplePropertyByName(String propertyName) {
        String shortName = propertyName.startsWith(BUNDLE_PREFIX) ? propertyName.substring(BUNDLE_PREFIX.length(), propertyName.length()) : propertyName;
        return shortNameToProperty.get(shortName);
    }

    public static String constructDisableServiceProperty(@NotNull String serviceId) {
        return BundleProperty.constructDisableServiceProperty(serviceId, true);
    }

    public static String constructDisableServiceProperty(@NotNull String serviceId, boolean prefixed) {
        return BundleProperty.constructServiceSpecificProperty(serviceId, PropertyPart.DISABLE, prefixed);
    }

    public static String constructPortBaseServiceProperty(@NotNull String serviceId) {
        return BundleProperty.constructServiceSpecificProperty(serviceId, PropertyPart.PORT_BASE, true);
    }

    public static String constructPortBaseServiceProperty(@NotNull String serviceId, boolean prefixed) {
        return BundleProperty.constructServiceSpecificProperty(serviceId, PropertyPart.PORT_BASE, prefixed);
    }

    private static String constructServiceSpecificProperty(@NotNull String serviceId, @NotNull PropertyPart part, boolean prefixed) {
        return part.getProperty(serviceId, prefixed);
    }

    public boolean isComputable() {
        return this.myIsComputable;
    }

    static {
        shortNameToProperty = new HashMap<String, BundleProperty>();
        for (BundleProperty property : BundleProperty.values()) {
            shortNameToProperty.put(property.getName(), property);
        }
    }

    private static enum PropertyPart {
        DISABLE("disable."),
        PORT_BASE("port-base.");

        private final String value;

        public String getProperty(@NotNull String serviceId, boolean prefixed) {
            return (prefixed ? BundleProperty.BUNDLE_PREFIX : "") + this.value + serviceId;
        }

        private PropertyPart(String part) {
            this.value = part;
        }

        static boolean isKnownProperty(@NotNull String propertyName) {
            for (PropertyPart part : PropertyPart.values()) {
                if (!propertyName.startsWith(part.value)) continue;
                return true;
            }
            return false;
        }
    }
}

