/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClazzLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ClazzLoader.class);

    public static void callMain(File[] libDir, String class2Name, String[] args) {
        try {
            ClazzLoader.callMethod(libDir, class2Name, "main", new Class[]{String[].class}, new Object[]{args});
        }
        catch (NoSuchMethodException e) {
            LOG.error("", (Throwable)e);
        }
    }

    public static void callMethod(File[] libDir, String class2Name, String methodName, Class[] paramTypes, Object[] paramValuesArray) throws NoSuchMethodException {
        ClazzLoader.callMethod(libDir, class2Name, methodName, paramTypes, paramValuesArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callMethod(File[] libDir, String class2Name, String methodName, Class[] paramTypes, Object[] paramValuesArray, ClassLoader parent) throws NoSuchMethodException {
        URLClassLoader cl = ClazzLoader.getClassLoaderByLibDir(libDir, parent);
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> aClass = cl.loadClass(class2Name);
            if (aClass.getClassLoader() != cl) {
                LOG.error("Failed to load class " + class2Name + " using new class loader");
            } else {
                Method method = aClass.getMethod(methodName, paramTypes);
                Object instance = Modifier.isStatic(method.getModifiers()) ? null : aClass.newInstance();
                method.invoke(instance, paramValuesArray);
            }
        }
        catch (NoSuchMethodException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                LOG.debug("", (Throwable)e);
            }
            LOG.warn("", e.getCause() == null ? e : e.getCause());
        }
        catch (Exception e) {
            LOG.warn("", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    @NotNull
    private static URLClassLoader getClassLoaderByLibDir(@NotNull File[] libDir, ClassLoader parent) {
        ArrayList<File> files = new ArrayList<File>();
        for (File dir : libDir) {
            File[] lfiles = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(@NotNull File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".jar");
                }
            });
            if (lfiles == null) continue;
            files.addAll(Arrays.asList(lfiles));
        }
        URL[] urls = new URL[files.size()];
        int i = 0;
        for (File file : files) {
            try {
                urls[i] = file.toURI().toURL();
                ++i;
            }
            catch (MalformedURLException e) {
                LOG.error("", (Throwable)e);
            }
        }
        return new URLClassLoader(urls, parent);
    }
}

