/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util;

import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.cmd.CmdUtil;
import com.jetbrains.service.util.cmd.ExecutionContext;
import com.jetbrains.service.util.cmd.ExecutionResult;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemUtil {
    public static final String LOOP_BACK_ADDRESS = "127.0.0.1";
    private static final int WAIT_FOR_HOSTNAME_OUTPUT_MS = 200;
    private static final int MAX_HOSTNAME_EXECUTION_TIME_MS = 5000;
    private static List<String> localHostNames;
    private static Logger LOG;

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().startsWith("linux");
    }

    public static boolean isMac() {
        String osName = System.getProperty("os.name");
        return osName.toLowerCase().startsWith("mac") || osName.toLowerCase().startsWith("darwin");
    }

    public static String getComputerName() {
        return System.getenv("COMPUTERNAME");
    }

    public static String getUserDnsDomain() {
        return System.getenv("USERDNSDOMAIN");
    }

    public static String getCustomDnsDomain() {
        return System.getProperty("jetbrains.bundle.installation.user.dns.domain");
    }

    @NotNull
    public static String getMostSuitableHostName() {
        List<String> localHostNames = SystemUtil.getLocalHostNames();
        return localHostNames.size() > 0 ? localHostNames.get(0).toLowerCase() : LOOP_BACK_ADDRESS;
    }

    @NotNull
    public static List<String> getLocalHostNames() {
        return SystemUtil.getLocalHostNames(false, false);
    }

    @NotNull
    public static List<String> getLocalHostNames(boolean includeLoopBack) {
        return SystemUtil.getLocalHostNames(includeLoopBack, false);
    }

    @NotNull
    private static List<String> getLocalHostNames(boolean includeLoopBack, boolean fromCache) {
        List<String> localHostNames = SystemUtil.loadHostNames(fromCache);
        if (includeLoopBack) {
            InetAddress loopBackAddress = InetAddress.getLoopbackAddress();
            localHostNames.add(loopBackAddress.getHostAddress());
            localHostNames.add(loopBackAddress.getHostName());
        }
        return new ArrayList<String>(localHostNames);
    }

    @NotNull
    private static List<String> calculateMostSuitableHostNames() {
        ArrayList<String> hostNames = new ArrayList<String>();
        try {
            if (SystemUtil.isWindows()) {
                String computerName = SystemUtil.getComputerName();
                if (computerName != null) {
                    String customUserDomain;
                    String userDomain = SystemUtil.getUserDnsDomain();
                    if (userDomain != null) {
                        hostNames.add(computerName + "." + userDomain);
                    }
                    if ((customUserDomain = SystemUtil.getCustomDnsDomain()) != null) {
                        hostNames.add(computerName + "." + customUserDomain);
                    }
                    hostNames.add(computerName);
                } else {
                    SystemUtil.addCmdOutputToHostNames("hostname", Collections.emptyList(), hostNames);
                }
            } else {
                SystemUtil.addCmdOutputToHostNames("hostname", Collections.singletonList("-f"), hostNames);
                SystemUtil.addCmdOutputToHostNames("hostname", Collections.singletonList("-s"), hostNames);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to resolve hostname", (Throwable)e);
        }
        return hostNames;
    }

    @NotNull
    private static List<String> filterLocalHostNames(@NotNull List<String> hostNames) {
        List<InetAddress> knownNetInterfaceAddresses;
        ArrayList<String> localHostNames = new ArrayList<String>();
        if (hostNames.isEmpty()) {
            return localHostNames;
        }
        if (hostNames.size() == 1 && LOOP_BACK_ADDRESS.equals(hostNames.get(0))) {
            localHostNames.add(LOOP_BACK_ADDRESS);
            return localHostNames;
        }
        try {
            knownNetInterfaceAddresses = SystemUtil.getKnownNetInterfaceAddresses();
            LOG.debug(String.format("Known Net Interfaces: %s", knownNetInterfaceAddresses.toString()));
        }
        catch (Throwable ignore) {
            LOG.debug("Can not resolve known net interfaces", ignore);
            return localHostNames;
        }
        for (String hostName : hostNames) {
            if (LOOP_BACK_ADDRESS.equals(hostName)) {
                localHostNames.add(hostName);
                continue;
            }
            if (SystemUtil.isKnownNetInterfaceAddress(hostName, knownNetInterfaceAddresses)) {
                localHostNames.add(hostName);
                continue;
            }
            LOG.debug(String.format("None of InetAddresses corresponding to %s belongs to known net interface of installation server", hostName));
        }
        return localHostNames;
    }

    private static boolean isKnownNetInterfaceAddress(String hostName, List<InetAddress> knownNetInterfaceAddresses) {
        try {
            Object[] hostNameAddresses = InetAddress.getAllByName(hostName);
            LOG.debug(String.format("InetAddress.getAllByName returned %s for %s", Arrays.toString(hostNameAddresses), hostName));
            if (hostNameAddresses == null) {
                return false;
            }
            for (Object address : hostNameAddresses) {
                if (!knownNetInterfaceAddresses.contains(address) && !((InetAddress)address).isLoopbackAddress()) continue;
                return true;
            }
        }
        catch (Throwable ignore) {
            LOG.debug(String.format("Can not resolve hostName %s", hostName), ignore);
        }
        return false;
    }

    private static List<InetAddress> getKnownNetInterfaceAddresses() throws SocketException {
        ArrayList<InetAddress> knownNetInterfaceAddresses = new ArrayList<InetAddress>();
        for (NetworkInterface ifc : Collections.list(NetworkInterface.getNetworkInterfaces())) {
            if (!ifc.isUp()) continue;
            knownNetInterfaceAddresses.addAll(Collections.list(ifc.getInetAddresses()));
        }
        return knownNetInterfaceAddresses;
    }

    public static String getNonLoopbackLocalHostIPAddress() {
        try {
            InetAddress candidateAddress = null;
            List<InetAddress> knownAddresses = SystemUtil.getKnownNetInterfaceAddresses();
            for (InetAddress inetAddress : knownAddresses) {
                if (inetAddress.isLoopbackAddress()) continue;
                if (inetAddress.isSiteLocalAddress()) {
                    return inetAddress.toString();
                }
                if (candidateAddress != null) continue;
                candidateAddress = inetAddress;
            }
            if (candidateAddress != null) {
                return candidateAddress.toString();
            }
            return null;
        }
        catch (Exception e) {
            LOG.debug("Cannot get non-loopback IP address", (Throwable)e);
            return null;
        }
    }

    private static void addCmdOutputToHostNames(@NotNull String cmd, List<String> additionalArguments, List<String> hostNames) {
        String output = SystemUtil.getCmdOutput(cmd, additionalArguments);
        if (output != null) {
            hostNames.add(output);
        }
    }

    private static String getCmdOutput(@NotNull String cmd, List<String> additionalArguments) {
        try {
            ExecutionContext context = new ExecutionContext();
            context.put(ExecutionContext.Param.executionTimeoutInMillis, 5000);
            context.put(ExecutionContext.Param.outputWaitTimeoutInMillis, 200);
            context.put(ExecutionContext.Param.logOutputToConsole, false);
            ExecutionResult result = CmdUtil.executeCommandWithExitCode(cmd, null, "command [" + cmd + "]", Collections.emptyList(), additionalArguments, context);
            if (result.exitCode == 0) {
                return result.myCommandOutput;
            }
        }
        catch (Throwable e) {
            LOG.warn(String.format("Failed run command [%s]", cmd), e);
        }
        return null;
    }

    public static void setTempDir(@NotNull Path tempDir) throws IOException {
        tempDir.toFile().mkdirs();
        if (!tempDir.toFile().isDirectory()) {
            throw new RuntimeException("Could not create temp directory: " + tempDir);
        }
        System.setProperty("java.io.tmpdir", tempDir.toString());
    }

    @NotNull
    public static Path relativizePath(@NotNull Path basePath, @NotNull Path path) {
        Path relativePath = path;
        if (path.startsWith(basePath)) {
            try {
                relativePath = basePath.relativize(path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return relativePath;
    }

    public static String checkFolderIsReadable(@NotNull File folder) {
        if (!folder.exists()) {
            if (Files.isSymbolicLink(folder.toPath())) {
                return String.format("Symbolic link %s points to non existing location", folder);
            }
            return String.format("Directory doesn't exist %s", folder);
        }
        if (!folder.isDirectory()) {
            return String.format("%s is not a directory", folder);
        }
        if (!Files.isReadable(folder.toPath())) {
            return String.format("Directory %s is not readable", folder);
        }
        return null;
    }

    public static String checkFolderIsWritable(@NotNull File folder) {
        if (!folder.exists() && !folder.mkdirs()) {
            if (Files.isSymbolicLink(folder.toPath())) {
                return String.format("Symbolic link %s points to non existing location", folder);
            }
            return String.format("Failed to create directory %s", folder);
        }
        if (!folder.isDirectory()) {
            return String.format("%s is not a directory", folder);
        }
        if (SystemUtil.isWindows()) {
            String error = SystemUtil.tryCreateAndModifyFile(folder);
            if (error != null) {
                return error;
            }
        } else if (!Files.isWritable(folder.toPath())) {
            return String.format("directory %s is not writable", folder);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String tryCreateAndModifyFile(@NotNull File folder) {
        Path tmpFilePath = folder.toPath().resolve("safe-to-delete-" + UUID.randomUUID());
        try {
            try {
                Files.createFile(tmpFilePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                String errorMessage = String.format("Directory %s is not writable. Error occurred while trying to create file inside that.", folder);
                LOG.info(errorMessage + ":" + e.getMessage());
                String string = errorMessage;
                try {
                    Files.deleteIfExists(tmpFilePath);
                }
                catch (IOException e2) {
                    LOG.debug(String.format("Failed to delete tmp file [%s]", tmpFilePath), (Throwable)e2);
                }
                return string;
            }
        }
        catch (Throwable throwable) {
            try {
                Files.deleteIfExists(tmpFilePath);
            }
            catch (IOException e) {
                LOG.debug(String.format("Failed to delete tmp file [%s]", tmpFilePath), (Throwable)e);
            }
            throw throwable;
        }
        try {
            Files.write(tmpFilePath, "test content".getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            String errorMessage = String.format("Directory %s is not writable. Error occurred while trying to modify tmp file inside that.", folder);
            LOG.info(errorMessage + ":" + e.getMessage());
            String string = errorMessage;
            try {
                Files.deleteIfExists(tmpFilePath);
            }
            catch (IOException e3) {
                LOG.debug(String.format("Failed to delete tmp file [%s]", tmpFilePath), (Throwable)e3);
            }
            return string;
        }
        try {
            Files.deleteIfExists(tmpFilePath);
        }
        catch (IOException e) {
            LOG.debug(String.format("Failed to delete tmp file [%s]", tmpFilePath), (Throwable)e);
        }
        return null;
    }

    public static String checkExistingFolder(Path directory) {
        if (!Files.exists(directory, new LinkOption[0])) {
            return String.format("Directory %s doesn't exist", directory);
        }
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return String.format("%s is not a directory", directory);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String checkExistingEmptyFolder(Path directory) {
        String existingFolderError = SystemUtil.checkExistingFolder(directory);
        if (existingFolderError != null) {
            return existingFolderError;
        }
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory);){
            String throwable3 = !dirStream.iterator().hasNext() ? null : String.format("Directory %s is not empty", directory);
            return throwable3;
        }
        catch (IOException e) {
            String errorMessage = String.format("Failed to check if directory %s is empty", directory);
            LOG.debug(errorMessage, (Throwable)e);
            return errorMessage;
        }
    }

    @NotNull
    public static Collection<String> getWithLocalHostSynonyms(@NotNull String serviceUrl, @NotNull Properties properties) {
        return SystemUtil.getWithLocalHostSynonyms(serviceUrl, properties, false);
    }

    @NotNull
    public static Collection<String> getWithLocalHostSynonyms(@NotNull String serviceUrl, @NotNull Properties properties, boolean useCache) {
        int bundleListenPort = Integer.parseInt(PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty(properties, BundleProperty.LISTEN_PORT.getPrefixedName()));
        return SystemUtil.getWithLocalHostSynonyms(serviceUrl, bundleListenPort, useCache);
    }

    @NotNull
    public static Collection<String> getWithLocalHostSynonyms(@NotNull String serviceUrl, int bundleListenPort) {
        return SystemUtil.getWithLocalHostSynonyms(serviceUrl, bundleListenPort, false);
    }

    @NotNull
    public static Collection<String> getWithLocalHostSynonyms(@NotNull String serviceUrl, int bundleListenPort, boolean useCache) {
        List<String> hostNames = SystemUtil.getLocalHostNames(true, useCache);
        return SystemUtil.getWithSynonyms(serviceUrl, bundleListenPort, hostNames);
    }

    @NotNull
    private static Collection<String> getWithSynonyms(@NotNull String serviceUrl, int bundleListenPort, @NotNull List<String> hostNames) {
        String fullHostName;
        int dotIdx;
        URL url;
        try {
            url = new URL(serviceUrl);
        }
        catch (MalformedURLException e) {
            return Collections.singletonList(serviceUrl);
        }
        ArrayList<URL> urlCollection = new ArrayList<URL>();
        urlCollection.add(url);
        if ("https".equalsIgnoreCase(url.getProtocol()) && (dotIdx = (fullHostName = url.getHost()).indexOf(46)) >= 0) {
            String shortHostName = fullHostName.substring(0, dotIdx);
            SystemUtil.addNewUrl(url, urlCollection, shortHostName);
        }
        for (String hostName : hostNames) {
            SystemUtil.addNewUrl(url, urlCollection, "http", hostName, bundleListenPort);
        }
        return SystemUtil.getFixedUrls(urlCollection);
    }

    @NotNull
    private static Set<String> getFixedUrls(@NotNull List<URL> urlCollection) {
        HashSet<String> urls = new HashSet<String>();
        for (URL url : urlCollection) {
            urls.add(url.toString());
            urls.add(SystemUtil.getUrlWithoutDefaultPort(url).toString());
        }
        return urls;
    }

    private static void addNewUrl(@NotNull URL url, @NotNull List<URL> urls, @NotNull String newHost) {
        SystemUtil.addNewUrl(url, urls, url.getProtocol(), newHost, url.getPort());
    }

    private static void addNewUrl(@NotNull URL url, @NotNull List<URL> urls, @NotNull String newProtocol, @NotNull String newHost, @NotNull Integer newPort) {
        try {
            URL newUrl = new URL(newProtocol, newHost, newPort, url.getFile());
            urls.add(newUrl);
        }
        catch (MalformedURLException e) {
            LOG.debug(String.format("Can not compose URL: %s", e.getMessage()), (Throwable)e);
        }
    }

    @NotNull
    private static URL getUrlWithoutDefaultPort(@NotNull URL url) {
        URL result = url;
        try {
            if ("http".equalsIgnoreCase(url.getProtocol()) && 80 == url.getPort()) {
                result = new URL(url.getProtocol(), url.getHost(), url.getFile());
            } else if ("https".equalsIgnoreCase(url.getProtocol()) && 443 == url.getPort()) {
                result = new URL(url.getProtocol(), url.getHost(), url.getFile());
            }
        }
        catch (MalformedURLException e) {
            LOG.debug(String.format("Can not compose URL: %s", e.getMessage()), (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static synchronized List<String> loadHostNames(boolean useCache) {
        if (useCache) {
            Class<SystemUtil> clazz = SystemUtil.class;
            synchronized (SystemUtil.class) {
                if (localHostNames == null) {
                    localHostNames = Collections.unmodifiableList(SystemUtil.filterLocalHostNames(SystemUtil.calculateMostSuitableHostNames()));
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new ArrayList<String>(localHostNames);
            }
        }
        return SystemUtil.filterLocalHostNames(SystemUtil.calculateMostSuitableHostNames());
    }

    public static void main(String[] args) throws Exception {
        Collection<String> urls = SystemUtil.getWithLocalHostSynonyms("https://host:443/ctx", 80);
        for (String url : urls) {
            System.out.println(url);
        }
    }

    public static void _main(String[] args) {
        int i;
        System.out.println("Calculated hostname = " + SystemUtil.getMostSuitableHostName());
        try {
            System.out.println("InetAddress.getLocalHost().getCanonicalHostName() = " + InetAddress.getLocalHost().getCanonicalHostName());
        }
        catch (UnknownHostException e) {
            System.out.println("InetAddress.getLocalHost().getCanonicalHostName() - FAILED!!!");
            e.printStackTrace();
        }
        System.out.println(System.getenv("COMPUTERNAME"));
        System.out.println(System.getenv("USERDNSDOMAIN"));
        ExecutionContext context = new ExecutionContext();
        context.put(ExecutionContext.Param.executionTimeoutInMillis, 5000);
        context.put(ExecutionContext.Param.outputWaitTimeoutInMillis, 200);
        context.put(ExecutionContext.Param.logOutputToConsole, true);
        ExecutionResult hostnameResult = CmdUtil.executeCommandWithExitCode("hostname", null, "command [hostname]", Collections.emptyList(), Collections.emptyList(), context);
        System.out.println("hostname_async.exitCode = " + hostnameResult.exitCode);
        System.out.println("hostname_async.output = " + hostnameResult.myCommandOutput);
        ExecutionResult hostname_F_Result = CmdUtil.executeCommandWithExitCode("hostname", null, "command [hostname]", Collections.emptyList(), Collections.singletonList("-f"), context);
        System.out.println("hostname_async_f.exitCode = " + hostname_F_Result.exitCode);
        System.out.println("hostname_async_f.output = " + hostname_F_Result.myCommandOutput);
        try {
            InetAddress[] addressesForHostName = InetAddress.getAllByName(hostnameResult.myCommandOutput);
            for (i = 0; i < addressesForHostName.length; ++i) {
                System.out.println("addressesForHostName[" + i + "].hostName = " + addressesForHostName[i].getHostName());
                System.out.println("addressesForHostName[" + i + "].address = " + addressesForHostName[i].getHostAddress());
                System.out.println("addressesForHostName[" + i + "].canonical = " + addressesForHostName[i].getCanonicalHostName());
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        List<String> localNames = SystemUtil.getLocalHostNames();
        for (i = 0; i < localNames.size(); ++i) {
            System.out.println("localNames[" + i + "].hostName = " + localNames.get(i));
        }
    }

    static {
        LOG = LoggerFactory.getLogger(SystemUtil.class);
    }
}

