/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;

public class TreeCopier
implements FileVisitor<Path> {
    private final Path source;
    private final Path target;
    private final boolean preserve;

    public TreeCopier(Path source, Path target, boolean preserve) {
        this.source = source;
        this.target = target;
        this.preserve = preserve;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        CopyOption[] copyOptionArray;
        if (this.preserve) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.COPY_ATTRIBUTES;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] options = copyOptionArray;
        Path newdir = this.target.resolve(this.source.relativize(dir));
        try {
            Files.copy(dir, newdir, options);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException x) {
            System.err.format("Unable to create: %s: %s%n", newdir, x);
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        TreeCopier.copyFile(file, this.target.resolve(this.source.relativize(file)), this.preserve);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
        if (exc == null && this.preserve) {
            Path newdir = this.target.resolve(this.source.relativize(dir));
            try {
                FileTime time = Files.getLastModifiedTime(dir, new LinkOption[0]);
                Files.setLastModifiedTime(newdir, time);
            }
            catch (IOException x) {
                System.err.format("Unable to copy all attributes to: %s: %s%n", newdir, x);
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        if (exc instanceof FileSystemLoopException) {
            System.err.println("cycle detected: " + file);
        } else {
            System.err.format("Unable to copy: %s: %s%n", file, exc);
        }
        return FileVisitResult.CONTINUE;
    }

    private static void copyFile(Path source, Path target, boolean preserve) {
        CopyOption[] copyOptionArray;
        if (preserve) {
            CopyOption[] copyOptionArray2 = new CopyOption[2];
            copyOptionArray2[0] = StandardCopyOption.COPY_ATTRIBUTES;
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[1] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            CopyOption[] copyOptionArray3 = new CopyOption[1];
            copyOptionArray = copyOptionArray3;
            copyOptionArray3[0] = StandardCopyOption.REPLACE_EXISTING;
        }
        CopyOption[] options = copyOptionArray;
        try {
            Files.copy(source, target, options);
        }
        catch (IOException x) {
            System.err.format("Unable to copy: %s: %s%n", source, x);
        }
    }
}

