/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util.properties.adapters;

import com.jetbrains.service.util.StatusException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class PropertySourceAdapter<T> {
    public abstract String get(@NotNull String var1, @NotNull T var2);

    public abstract void set(@NotNull String var1, String var2, @NotNull T var3);

    public abstract Set<String> stringPropertyNames(@NotNull T var1);

    public abstract boolean containsKey(@NotNull String var1, @NotNull T var2);

    @NotNull
    public final String getMandatory(@NotNull String propertyName, @NotNull T allProperties) {
        String value = this.get(propertyName, allProperties);
        this.checkNotNullProperty(value, propertyName);
        return value;
    }

    public void checkNotNullProperty(String value, @NotNull String propertyName) {
        if (value == null) {
            throw new StatusException(String.format("Mandatory config property '%s' is not found", propertyName));
        }
    }
}

