/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util.ssl;

import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.properties.ServiceConfigurationHelper;
import com.jetbrains.service.util.ssl.CompositeX509KeyManager;
import com.jetbrains.service.util.ssl.CompositeX509TrustManager;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeystoreUtil {
    @NotNull
    public static KeyStore loadKeyStore(@NotNull String keyStorePathAsString, @Nullable String storePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        return KeystoreUtil.loadKeyStore(Paths.get(keyStorePathAsString, new String[0]), storePassword);
    }

    @NotNull
    public static KeyStore loadKeyStore(@NotNull Path keyStorePath, @Nullable String storePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        KeystoreUtil.loadToExistingKeyStore(keyStore, keyStorePath, storePassword);
        return keyStore;
    }

    public static void loadToExistingKeyStore(@NotNull KeyStore keyStore, @NotNull Path keyStorePath, @Nullable String storePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (!Files.exists(keyStorePath, new LinkOption[0])) {
            keyStore.load(null, null);
        } else {
            try (FileInputStream fis = new FileInputStream(keyStorePath.toFile());){
                char[] password = storePassword != null ? storePassword.toCharArray() : null;
                keyStore.load(fis, password);
            }
        }
    }

    public static void saveKeyStore(@NotNull KeyStore keyStore, @NotNull String keyStorePathAsString, @Nullable String storePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeystoreUtil.saveKeyStore(keyStore, Paths.get(keyStorePathAsString, new String[0]), storePassword);
    }

    public static void saveKeyStore(@NotNull KeyStore keyStore, @NotNull Path keyStorePath, @Nullable String storePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        Path keystoreParentPath = keyStorePath.getParent();
        if (keystoreParentPath != null && !Files.exists(keystoreParentPath, new LinkOption[0])) {
            Files.createDirectories(keystoreParentPath, new FileAttribute[0]);
        }
        char[] password = storePassword != null ? storePassword.toCharArray() : null;
        try (FileOutputStream out = new FileOutputStream(keyStorePath.toFile());){
            keyStore.store(out, password);
        }
    }

    @NotNull
    public static CompositeX509TrustManager buildCompositeTrustManager(@Nullable KeyStore additionalKeyStore, @Nullable KeyStore temporaryKeyStore) throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException {
        ArrayList<X509TrustManager> managers = new ArrayList<X509TrustManager>();
        String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        X509TrustManager jvmTrustManager = KeystoreUtil.getTrustManager(defaultAlgorithm, null);
        managers.add(jvmTrustManager);
        if (temporaryKeyStore != null) {
            managers.add(KeystoreUtil.getTrustManager("SunX509", temporaryKeyStore));
        }
        if (additionalKeyStore != null) {
            managers.add(KeystoreUtil.getTrustManager("SunX509", additionalKeyStore));
        }
        return new CompositeX509TrustManager(managers.toArray(new X509TrustManager[managers.size()]));
    }

    @NotNull
    public static CompositeX509KeyManager buildCompositeKeyManager(@Nullable KeyStore additionalKeyStore, @Nullable String additionalHubKeyPassword, @Nullable KeyStore temporaryKeyStore) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, IOException, CertificateException {
        ArrayList<X509KeyManager> managers = new ArrayList<X509KeyManager>();
        String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        X509KeyManager jvmKeyManager = KeystoreUtil.getKeyManager(defaultAlgorithm, null, null);
        managers.add(jvmKeyManager);
        if (temporaryKeyStore != null) {
            managers.add(KeystoreUtil.getKeyManager("SunX509", temporaryKeyStore, additionalHubKeyPassword));
        }
        if (additionalKeyStore != null && additionalHubKeyPassword != null) {
            managers.add(KeystoreUtil.getKeyManager("SunX509", additionalKeyStore, additionalHubKeyPassword));
        }
        return new CompositeX509KeyManager(managers.toArray(new X509KeyManager[managers.size()]));
    }

    @Nullable
    public static X509KeyManager getKeyManager(@NotNull String algorithm, @Nullable KeyStore keystore, @Nullable String keyPassword) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        KeyManager[] keyManagers;
        KeyManagerFactory factory = KeyManagerFactory.getInstance(algorithm);
        char[] password = keyPassword != null ? keyPassword.toCharArray() : null;
        factory.init(keystore, password);
        for (KeyManager keyManager : keyManagers = factory.getKeyManagers()) {
            if (!(keyManager instanceof X509KeyManager)) continue;
            return (X509KeyManager)keyManager;
        }
        return null;
    }

    @Nullable
    public static X509TrustManager getTrustManager(@NotNull String algorithm, @Nullable KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManager[] trustManagers;
        TrustManagerFactory factory = TrustManagerFactory.getInstance(algorithm);
        factory.init(keystore);
        for (TrustManager trustManager : trustManagers = factory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        return null;
    }

    @NotNull
    public static SSLContext buildSSLContext(@NotNull String additionalKeyStorePath, @Nullable String additionalKeystorePassword, @Nullable String additionalHubKeyPassword) throws NoSuchAlgorithmException, KeyManagementException, CertificateException, KeyStoreException, IOException, UnrecoverableKeyException {
        KeyStore additionalKeyStore = KeystoreUtil.loadKeyStore(additionalKeyStorePath, additionalKeystorePassword);
        CompositeX509KeyManager compositeX509KeyManager = additionalHubKeyPassword != null ? KeystoreUtil.buildCompositeKeyManager(additionalKeyStore, additionalHubKeyPassword, null) : KeystoreUtil.buildCompositeKeyManager(null, null, null);
        CompositeX509TrustManager compositeX509TrustManager = KeystoreUtil.buildCompositeTrustManager(additionalKeyStore, null);
        SSLContext context = SSLContext.getInstance("SSL");
        context.init(new KeyManager[]{compositeX509KeyManager}, new TrustManager[]{compositeX509TrustManager}, null);
        return context;
    }

    @Nullable
    public static <T> SSLContext buildSSLContext(@NotNull ServiceConfigurationHelper<T> propertiesHelper, @NotNull T properties) throws NoSuchAlgorithmException, KeyManagementException, CertificateException, KeyStoreException, IOException, UnrecoverableKeyException {
        String additionalKeyStorePath = propertiesHelper.getServiceProperty(properties, BundleProperty.ADDITIONAL_KEYSTORE_PATH.getPrefixedName());
        if (additionalKeyStorePath != null) {
            return KeystoreUtil.buildSSLContext(additionalKeyStorePath, propertiesHelper.getServiceProperty(properties, BundleProperty.ADDITIONAL_KEYSTORE_PASSWORD.getPrefixedName()), propertiesHelper.getServiceProperty(properties, BundleProperty.ADDITIONAL_KEYSTORE_HUB_KEY_PASSWORD.getPrefixedName()));
        }
        return null;
    }
}

